<?php $__env->startPush('css-app'); ?>
<style>

</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php use App\Http\Traits\Helper; ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="card border-0  my-2">
    <div class="card-body">
        <form id="formSite" method="post">
            <div class="form-group">
                <label>Site Name</label>
                <input type="text" name="sitename" id="sitename" value="<?php echo e($data->sitename); ?>" class="form-control" />
            </div>
            <div class="form-group">
                <label>Site Code  <small class="text-danger" id="site_code_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Invalid Site Code</small></label>
                <input type="text" name="site_code" id="site_code" value="<?php echo e($data->site_code); ?>" class="form-control" />
            </div>
            <div class="form-group">
                <label>Division ID</label>
                <input type="text" name="divison_id" id="divison_id" value="<?php echo e($data->divison_id); ?>" class="form-control" />
            </div>
            <div class="form-group">
                <label>Site Key  <small class="text-danger" id="key_outlet_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Invalid Site Key</small></label>
                <input type="text" name="key_outlet" id="key_outlet" value="<?php echo e($data->key_outlet); ?>" class="form-control" />
            </div>
            <div class="form-group">
                <label>Location ID</label>
                <input type="text" name="location_id" id="location_id" value="<?php echo e($data->location_id); ?>" class="form-control" />
            </div>
            <div class="form-group">
                <label>Store Availibility</label>
                <select id="store_availibility" name="store_availibility" id="id_brand" class="form-control">
                    <option value="1" <?php if($data->store_availibility == 1): ?> selected <?php endif; ?>>Operation</option>
                    <option value="2" <?php if($data->store_availibility == 2): ?> selected <?php endif; ?>>Renovation</option>
                    <option value="3" <?php if($data->store_availibility == 3): ?> selected <?php endif; ?> >Close</option>
                </select>
            </div>
            <div class="form-group">
                <label>Brand</label>
                <select id="id_brand" name="id_brand" id="id_brand" class="form-control">
                    <?php $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id_brand); ?>" <?php if($item->id_brand == $data->id_brand): ?> selected <?php endif; ?>><?php echo e($item->nama_brand); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <label>Province</label>
                <select id="id_provinsi" name="id_provinsi" id="id_provinsi" class="form-control">
                    <option value="0">Choose Province</option>
                    <?php $__currentLoopData = $provinsi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id_provinsi); ?>" <?php if($item->id_provinsi == $data->id_provinsi): ?> selected <?php endif; ?>><?php echo e($item->nama_provinsi); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <label>City</label>
                <select id="id_kota" name="id_kota" id="id_kota" class="form-control">
                    <?php $__currentLoopData = $kota; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id_kota); ?>" <?php if($item->id_kota == $data->id_kota): ?> selected <?php endif; ?>><?php echo e($item->nama_kota); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <button type="submit" id="submit_btn" class="btn btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="notifInvalid" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Error</h5>
                <button type="button" class="close notifInvalidClose" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="text_notif">Duplicate Site Code or Duplicate Key!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary notifInvalidClose" data-dismiss="modal">Ok</button>
            </div>
        </div>
    </div>
</div>

<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

<script>
    var site_id = <?php echo e($data->site_id); ?>;
   $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $('.notifInvalidClose').click(function () {
        $('#notifInvalid').modal('hide');
    });
    base_url = '@ViewBag.url';
    $('#id_provinsi').change(function (e) {
        AjaxKota();
    });
    function AjaxKota() {
        $('#id_kota').html("");
        var request = $.ajax({
            url: "<?php echo e(url('site/CariKotaAll')); ?>" + "/" + $("#id_provinsi").val(),
            method: "GET",
            dataType: "json",
            success: function (result) {
                for (var i = 0; i < result.length; i++) {
                    $("#id_kota").append("<option value='" + result[i].id_kota + "'>" + result[i].nama_kota +"</option>");
                }
            }
        });
    }
    function cekSite() {
        var data = new FormData();
        data.append('site_key', $('#key_outlet').val());
        data.append('site_code', $('#site_code').val());
        data.append('site_name', $('#sitename').val());
        data.append('site_id', site_id);
        $.ajax({
            url: "<?php echo e(url('site/cekSiteKey')); ?>",
            method: "POST",
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            data: data,
            dataType: "json",
            success: function (result) {

                if (result.cek_name) {
                    if (result.cek_site) {
                        if (result.cek_key) {
                            do_ajax();
                        } else {
                            $('#notifInvalid').modal('show');
                            $('#text_notif').html('Duplicate/Wrong Key!');
                            $('#submit_btn').attr('disabled', false);
                        }
                    } else {
                        $('#notifInvalid').modal('show');
                        $('#text_notif').html('Duplicate Site Code');
                        $('#submit_btn').attr('disabled', false);
                    }
                } else {
                    $('#notifInvalid').modal('show');
                    $('#text_notif').html('Duplicate/Empty Sitename');
                    $('#submit_btn').attr('disabled', false);
                }

            }
        });
    }
    function do_ajax() {
        //var data = $('#formSite').serialize();
        var data = new FormData();
        data.append('sitename', $('#sitename').val());
        data.append('site_code', $('#site_code').val());
        data.append('divison_id', $('#divison_id').val());
        data.append('key_outlet', $('#key_outlet').val());
        data.append('id_brand', $('#id_brand').val());
        data.append('id_provinsi', $('#id_provinsi').val());
        data.append('id_kota', $('#id_kota').val());
        data.append('location_id', $('#location_id').val());
        data.append('site_id', site_id);
            data.append('store_availibility', $('#store_availibility').val());
        $.ajax({
            type: "POST",
            url: "<?php echo e(url('site/save-edit')); ?>", // Replace with your server endpoint
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            data: data,
            success: function (response) {
                // Handle the response from the server
                console.log(response);
                $('#submit_btn').attr('disabled', false);
                window.location = "<?php echo e(url('site')); ?>";
            },
            error: function (error) {
                // Handle errors
                console.log(error);
            }
        });
    }
    $("#formSite").submit(function (e) {
        e.preventDefault();
        $('#submit_btn').attr('disabled', true);
        cekSite();
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/php74/people_counting/resources/views/site/edit.blade.php ENDPATH**/ ?>