<?php $__env->startPush('css-app'); ?>
<style>
    #sortable1, #sortable2 {
        /*border: 1px solid #eee;*/
        width: 100%;
        min-height: 14rem;
        list-style-type: none;
        margin: 0;
        padding: 5px 0 0 0;
        float: left;
        margin-right: 10px;
    }
    
    #sortable1 li, #sortable2 li {
        margin: 0 5px 5px 5px;
        padding: 5px;
        font-size: 1rem;
        width: 120px;
        text-align: center;
    }
    .ui-state-default {
        border: 1px solid #eee;
    }
    #save_approval {
        margin-left: 0.75rem;
        margin-top:1rem;
    }
    .col-12 {
        margin-top:1rem;
    }
    .title-site {
        font-size: 2rem;
        font-weight:800;
    }
    .list-device {
        font-size: 1.2rem;
        font-weight: 600;
    }
    .card {
        border: 1px dashed #858796 !important;
        margin-right: 10rem;
        min-height:16rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="row">
    <div class="title-site col-12">@ViewBag.sitename</div>
    <div class="list-device col-12">List Device</div>
    <div class="col-6">
        <div class="card border-0  my-2">
            <div class="card-body">
                <div>Pending</div>
                <ul id="sortable1" class="connectedSortable">
                    <?php $__currentLoopData = $list_pending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="ui-state-default" data-id="<?php echo e($item->device_id); ?>"><?php echo e($item->device_name); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="col-6">
        <div class="card border-0  my-2">
            <div class="card-body">
                <div>Approved</div>
                <ul id="sortable2" class="connectedSortable">
                    <?php $__currentLoopData = $list_approved; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="ui-state-default" data-id="<?php echo e($item->device_id); ?>"><?php echo e($item->device_name); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
    <div class="form-group">
        <button type="button" id="save_approval" class="btn btn-primary">Simpan</button>
    </div>
</div>
<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    var id = <?php echo e($id); ?>;
    var is_lite = 0;
    $(function() {
        $( "#sortable1, #sortable2" ).sortable({
            connectWith: ".connectedSortable",
            receive: function (event, ui) {
                if (is_lite == 1) {
                    if ($(this).attr('id') == 'sortable2' && $(this).children().length > 5) {
                        $(ui.sender).sortable('cancel'); // Revert the move
                    }
                }
            }
        }).disableSelection();
    });
    $('#save_approval').click(function () {
        var dataIdArray = [];

        $("#sortable1 li").each(function () {
            var dataIdValue = $(this).data("id");
            dataIdArray.push(dataIdValue);
        });

        var dataIdArray2 = [];

        $("#sortable2 li").each(function () {
            var dataIdValue2 = $(this).data("id");
            dataIdArray2.push(dataIdValue2);
        });

        var data_pending = dataIdArray.join(",");
        var data_approved = dataIdArray2.join(",");
        $.ajax({
            method: "GET",
            url: "<?php echo e(url('site/approval')); ?>" + "?id=" + id + "&list_approved=" + data_approved + "&list_pending="+data_pending,
            success: function (e) {
                window.location = "<?php echo e(url('site')); ?>";
            }
        });
    });
   
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/php74/people_counting/resources/views/site/approvalDevice.blade.php ENDPATH**/ ?>