<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CLogin;
use App\Http\Controllers\CDashboard;
use App\Http\Controllers\CDamageDetection;
use App\Http\Controllers\CReport;
use App\Http\Controllers\CProvinsi;
use App\Http\Controllers\CKota;
use App\Http\Controllers\CRuas;
use App\Http\Controllers\CUser;
use App\Http\Controllers\CApi;
use App\Http\Controllers\CBrand;
use App\Http\Controllers\CSite;
use App\Http\Controllers\CDevice;
use App\Http\Controllers\CBussiness;
use App\Http\Controllers\CExcel;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/login', [CLogin::class,'index'])->middleware("guest");
Route::post('/auth',[CLogin::class,'authenticate']);
Route::get('/logout',[CLogin::class,'logout']);
Route::get('create-pass',[CDashboard::class,'create_pass']);
Route::post('/save-data-camera-v1',[CApi::class,'postCamera']);
// Route::post('/save-data-camera',[CApi::class,'postCameraByPass']);
Route::post('/save-data-camera/{bussiness_code}',[CApi::class,'postCameraParam']);
Route::get('/test-data',[CBussiness::class,'test_data']);
Route::post('/read-csv',[CExcel::class,'readCsv']);
Route::get('/upload-csv',[CExcel::class,'uploadCsv']);
Route::middleware(['auth','connectDb'])->group(function()
{
    Route::get('/',[CDashboard::class,'index']);
    Route::get('/dashboard',[CDashboard::class,'index']);

    //home
    Route::post('/home/dashboardTotalData',[CDashboard::class,'dashboardTotalData']);
    Route::post('/home/dashboardDailyLocation',[CDashboard::class,'dashboardDailyLocation']);
    Route::post('/home/dashboardWeeklyLocation',[CDashboard::class,'dashboardWeeklyLocation']);
    Route::post('/home/dashboardMonthlyLocation',[CDashboard::class,'dashboardMonthlyLocation']);
    Route::post('/home/dashboardYearlyLocation',[CDashboard::class,'dashboardYearlyLocation']);
    Route::post('/home/dashboardDailyTrendCustom',[CDashboard::class,'dashboardDailyTrendCustom']);
    Route::post('/home/dashboardDailyTrend',[CDashboard::class,'dashboardDailyTrend']);
    Route::post('/home/dashboardWeeklyTrendV2',[CDashboard::class,'dashboardWeeklyTrendV2']);
    Route::post('/home/dashboardMonthlyTrendV2',[CDashboard::class,'dashboardMonthlyTrendV2']);
    Route::post('/home/dashboardYearlyTrendV2',[CDashboard::class,'dashboardYearlyTrendV2']);
    Route::post('/home/peoplecountdata',[CDashboard::class,'peoplecountdata']);
    Route::post('/home/tddaily',[CDashboard::class,'tddaily']);
    Route::post('/home/tdweekly',[CDashboard::class,'tdweekly']);
    Route::post('/home/tdmonthly',[CDashboard::class,'tdmonthly']);
    Route::post('/home/tdyearly',[CDashboard::class,'tdyearly']);
    Route::post('/home/drcustom',[CDashboard::class,'drcustom']);
    Route::post('/home/drhourly',[CDashboard::class,'drhourly']);
    Route::post('/home/drdaily',[CDashboard::class,'drdaily']);
    Route::post('/home/drweekly',[CDashboard::class,'drweekly']);
    Route::post('/home/drmonthly',[CDashboard::class,'drmonthly']);
    Route::post('/home/dryearly',[CDashboard::class,'dryearly']);
    Route::get('/test-download',[CDashboard::class,'test_download']);
    Route::post('/download/people-count-xlsx',[CDashboard::class,'peoplecountxlsx']);
    Route::post('/download/people-count-csv',[CDashboard::class,'peoplecountcsv']);
    Route::post('/download/table-degradation-daily-xlsx',[CDashboard::class,'tddxlsx']);
    Route::post('/download/table-degradation-daily-csv',[CDashboard::class,'tddcsv']);
    Route::post('/download/table-degradation-weekly-xlsx',[CDashboard::class,'tdwxlsx']);
    Route::post('/download/table-degradation-weekly-csv',[CDashboard::class,'tdwcsv']);
    Route::post('/download/table-degradation-monthly-xlsx',[CDashboard::class,'tdmxlsx']);
    Route::post('/download/table-degradation-monthly-csv',[CDashboard::class,'tdmcsv']);
    Route::post('/download/table-degradation-yearly-xlsx',[CDashboard::class,'tdyxlsx']);
    Route::post('/download/table-degradation-yearly-csv',[CDashboard::class,'tdycsv']);
    Route::post('/download/dashboard-range-hourly-xlsx',[CDashboard::class,'drhxlsx']);
    Route::post('/download/dashboard-range-hourly-csv',[CDashboard::class,'drhcsv']);
    Route::post('/download/dashboard-range-daily-xlsx',[CDashboard::class,'drdxlsx']);
    Route::post('/download/dashboard-range-daily-csv',[CDashboard::class,'drdcsv']);
    Route::post('/download/dashboard-range-weekly-xlsx',[CDashboard::class,'drwxlsx']);
    Route::post('/download/dashboard-range-weekly-csv',[CDashboard::class,'drwcsv']);
    Route::post('/download/dashboard-range-monthly-xlsx',[CDashboard::class,'drmxlsx']);
    Route::post('/download/dashboard-range-monthly-csv',[CDashboard::class,'drmcsv']);
    Route::post('/download/dashboard-range-yearly-xlsx',[CDashboard::class,'dryxlsx']);
    Route::post('/download/dashboard-range-yearly-csv',[CDashboard::class,'drycsv']);
    
    //Brand
    Route::get('/brand',[CBrand::class,'index']);
    Route::get('/brand/get-data',[CBrand::class,'get_data']);
    Route::get('/brand/create',[CBrand::class,'create']);
    Route::post('/brand/save',[CBrand::class,'create_save']);
    Route::get('/brand/edit/{id}',[CBrand::class,'edit']);
    Route::post('/brand/save-edit',[CBrand::class,'edit_save']);
    Route::get('/brand/delete/{id}',[CBrand::class,'delete']);
    Route::get('/brand/CariBrandAll/{id}',[CBrand::class,'CariBrandAll']);
    
    //site
    Route::get('/site',[CSite::class,'index']);
    Route::get('/site/get-data',[CSite::class,'get_data']);
    Route::get('/site/create',[CSite::class,'create']);
    Route::post('/site/save',[CSite::class,'create_save']);
    Route::get('/site/edit/{id}',[CSite::class,'edit']);
    Route::post('/site/save-edit',[CSite::class,'edit_save']);
    Route::get('/site/delete/{id}',[CSite::class,'delete']);
    Route::get('/site/CariKotaAll/{id}',[CSite::class,'CariKotaAll']);
    Route::get('/site/CariSiteAll/{id}',[CSite::class,'CariSiteAll']);
    Route::get('/site/CariSiteAllV2/{id}/{id_provinsi}',[CSite::class,'CariSiteAllV2']);
    Route::post('/site/cekSiteKey',[CSite::class,'cekSiteKey']);
    Route::get('/site/ApprovalDevice/{id}',[CSite::class,'ApprovalDevice']);
    Route::get('/site/approval/',[CSite::class,'approval']);
    Route::get('/site/detail/{id}',[CSite::class,'detail']);

    //device
    Route::get('/device',[CDevice::class,'index']);
    Route::get('/device/get-data',[CDevice::class,'get_data']);
    Route::get('/device/create',[CDevice::class,'create']);
    Route::post('/device/save',[CDevice::class,'create_save']);
    Route::get('/device/edit/{id}',[CDevice::class,'edit']);
    Route::post('/device/save-edit',[CDevice::class,'edit_save']);
    Route::get('/device/delete/{id}',[CDevice::class,'delete']);
    Route::get('/device/detail/{id}',[CDevice::class,'detail']);

    //Bussiness
    Route::get('/bussiness',[CBussiness::class,'index']);
    Route::get('/bussiness/get-data',[CBussiness::class,'get_data']);
    Route::get('/bussiness/create',[CBussiness::class,'create']);
    Route::post('/bussiness/save',[CBussiness::class,'create_save']);
    Route::get('/bussiness/edit/{id}',[CBussiness::class,'edit']);
    Route::post('/bussiness/save-edit',[CBussiness::class,'edit_save']);
    Route::get('/bussiness/delete/{id}',[CBussiness::class,'delete']);

    //User
    Route::get('/user',[CUser::class,'index']);
    Route::get('/user/get-data',[CUser::class,'get_data']);
    Route::get('/user/create',[CUser::class,'create']);
    Route::post('/user/save',[CUser::class,'create_save']);
    Route::get('/user/edit/{id}',[CUser::class,'edit']);
    Route::post('/user/save-edit',[CUser::class,'edit_save']);
    Route::get('/user/delete/{id}',[CUser::class,'delete']);
    Route::get('/user/cari-provinsi/{id}',[CUser::class,'cariProvinsi']);
    Route::get('change-password/',[CUser::class,'changePassword']);
    Route::post('/user/save-password',[CUser::class,'password_save']);
});
