@push('css-app')
<style>
    .btn-tranparent {
        font-size: 0.82rem;
        color: #2E526B !important;
        font-weight: 400;
        line-height: 1.5;
        box-shadow: 0 0 0 0 transparent !important;
        vertical-align: unset;
        padding: 0;
        text-align: left;
        border: 0px solid transparent;
        border-radius: 0px;
    }
</style>
@endpush
@extends('template')
@section('content')
<div class="card border-0  my-2">
    <div class="card-body">
        <a href="{{url('bussiness/create')}}" class='btn btn-primary mb-3'><i class='fas fa-plus-circle'></i>Tambah</a>
        <table class="table table-striped" id="table">
            <thead>
            <th>Bussiness Name</th>
            <th>Bussiness Code</th>
            <th>Action</th>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
@endsection
@push('js')

<script>
    function load_data(){
        table = $('#table').AppTable({
            url: '{{url("bussiness/get-data")}}',
            column: [
                { "data": "bussiness_name", "name": "bussiness_name" },
                { "data": "bussiness_code", "name": "bussiness_code" },
                {
                    "data": "bussiness_id",
                    sortable: false,
                    "render": function (data, type, row) {
                        var id = data;
                        return "<div class='dropdown'>\
                                <button class='btn btn-tranparent dropdown-toggle' type='button' id='dropdownMenuButton' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false' >\
                                    <i class='fas fa-ellipsis-h'></i>\
                                </button>\
                                <div class='dropdown-menu' aria-labelledby='dropdownMenuButton'>\
                                    <a class='dropdown-item' href='{{url("bussiness/edit")}}/" + id +"'>Edit</a>\
                                </div>\
                            </div>";
                    }
                },
            ],

        })
    }
    load_data();
</script>
@endpush