DROP TABLE IF EXISTS "api_logs";
DROP SEQUENCE IF EXISTS api_logs_id_seq;
CREATE SEQUENCE api_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."api_logs" (
    "id" integer DEFAULT nextval('api_logs_id_seq') NOT NULL,
    "site_id" integer,
    "device_id" integer,
    "ip_address" character varying(150),
    "json" text,
    "report_date" timestamp,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT "api_logs_pkey" PRIMARY KEY ("id")
) WITH (oids = false);

INSERT INTO "api_logs" ("id", "site_id", "device_id", "ip_address", "json", "report_date", "created_at") VALUES
(1,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:01:17.907791'),
(2,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:13.989771'),
(3,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:15.976738'),
(4,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:16.996596'),
(5,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:17.980281'),
(6,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:18.794252'),
(7,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:19.628713'),
(8,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:20.562996'),
(9,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:21.268214'),
(10,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:22.061815'),
(11,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:22.786936'),
(12,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:23.672964'),
(13,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:24.514965'),
(14,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:25.353576'),
(15,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:26.122652'),
(16,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:36.6769'),
(17,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:37.493551'),
(18,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:38.324857'),
(19,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:39.173375'),
(20,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:39.911118'),
(21,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:40.660558'),
(22,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:41.415789'),
(23,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:42.15848'),
(24,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:42.906814'),
(25,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:43.632181'),
(26,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:44.338567'),
(27,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:45.106456'),
(28,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:45.9525'),
(29,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:46.615431'),
(30,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:47.457329'),
(31,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:48.153242'),
(32,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:48.93194'),
(33,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:49.698314'),
(34,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:50.450735'),
(35,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:51.314915'),
(36,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:52.204631'),
(37,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:53.027682'),
(38,	4,	3,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY005","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:05:53.883428'),
(39,	1,	4,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY003","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"00:00:00","EndTime":"01:00:00","UnixStartTime":"1704128400","Enters":"0","Exits":"0","Status":"0"}}}}}}',	'2024-01-18 01:00:00',	'2024-07-09 22:06:02.47327'),
(40,	1,	4,	'192.168.0.10',	'{"@attributes":{"SiteId":"DKY003","Sitename":"Diky Shoes 1","DeviceId":"DKY005","Devicename":"Device 1","DivisionId":"LB","type":"2"},"Properties":{"Version":"5","TransmitTime":"1704132246","MacAddress":"00:b0:9d:e9:fe:de","IpAddress":"192.168.0.10","HostName":"Cam-15335134","HttpPort":"80","HttpsPort":"443","Timezone":"7","TimezoneName":"(GMT 07:00) Bangkok, Hanoi, Jakarta","DST":"0","HwPlatform":"2300","SerialNumber":"15335134","DeviceType":"0","SwRelease":"5.7.14.568"},"ReportData":{"@attributes":{"Interval":"60"},"Report":{"@attributes":{"Date":"2024-01-18"},"Object":{"@attributes":{"Id":"0","DeviceId":"A01","Devicename":"Device 1","ObjectType":"0","Name":"Device 1"},"Count":{"@attributes":{"StartTime":"09:00:00","EndTime":"10:00:00","UnixStartTime":"1704128400","Enters":"10","Exits":"5","Status":"0"}}}}}}',	'2024-01-18 10:00:00',	'2024-07-09 22:06:34.251952');

DROP TABLE IF EXISTS "flying_tiger_logs";
DROP SEQUENCE IF EXISTS flying_tiger_logs_id_seq;
CREATE SEQUENCE flying_tiger_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."flying_tiger_logs" (
    "id" integer DEFAULT nextval('flying_tiger_logs_id_seq') NOT NULL,
    "url" character varying,
    "json" character varying,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "result" text,
    "site_id" integer,
    CONSTRAINT "flying_tiger_logs_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "login_logs";
DROP SEQUENCE IF EXISTS login_logs_id_seq;
CREATE SEQUENCE login_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."login_logs" (
    "id" integer DEFAULT nextval('login_logs_id_seq') NOT NULL,
    "id_user" integer,
    "status" integer,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT "login_logs_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "m_brand";
DROP SEQUENCE IF EXISTS m_brand_id_brand_seq;
CREATE SEQUENCE m_brand_id_brand_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_brand" (
    "id_brand" integer DEFAULT nextval('m_brand_id_brand_seq') NOT NULL,
    "nama_brand" character varying(150),
    "created_by" integer,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "edited_by" integer,
    "edited_at" timestamp,
    "deleted" smallint DEFAULT '1',
    CONSTRAINT "m_brand_pkey" PRIMARY KEY ("id_brand")
) WITH (oids = false);

INSERT INTO "m_brand" ("id_brand", "nama_brand", "created_by", "created_at", "edited_by", "edited_at", "deleted") VALUES
(1,	'Brand 1',	NULL,	'2024-06-11 08:16:40.88565',	NULL,	NULL,	1),
(2,	'Brand 21',	1,	'2024-06-13 23:13:38.699248',	1,	NULL,	0),
(3,	'Brand 2',	1,	'2024-06-13 23:41:17.375046',	0,	NULL,	1);

DROP TABLE IF EXISTS "m_device";
DROP SEQUENCE IF EXISTS m_device_device_id_seq;
CREATE SEQUENCE m_device_device_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_device" (
    "device_id" integer DEFAULT nextval('m_device_device_id_seq') NOT NULL,
    "site_id" integer,
    "device_code" character varying(150),
    "device_name" character varying(150),
    "ip_address" character varying,
    "hostname" text,
    "serial_number" text,
    "object_type" integer,
    "external_id" character varying(250),
    "last_report" timestamp,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "status" smallint,
    "deleted" smallint DEFAULT '1',
    "status_record" smallint,
    "camera_type" smallint,
    "camera_type_val" character varying(100),
    CONSTRAINT "m_device_pkey" PRIMARY KEY ("device_id")
) WITH (oids = false);

INSERT INTO "m_device" ("device_id", "site_id", "device_code", "device_name", "ip_address", "hostname", "serial_number", "object_type", "external_id", "last_report", "created_at", "status", "deleted", "status_record", "camera_type", "camera_type_val") VALUES
(1,	1,	'D01',	'Device 1',	'182.123.53.1',	NULL,	NULL,	NULL,	NULL,	'2024-07-02 08:06:52.726878',	'2024-07-02 08:06:52.726878',	0,	1,	1,	NULL,	NULL),
(2,	2,	'DV02',	'Device 21',	'test1',	'12',	'12',	0,	'1',	NULL,	'2024-07-05 08:26:08.117835',	1,	1,	1,	NULL,	NULL),
(3,	4,	'DKY005',	'Device 1',	'192.168.0.10',	'Cam-15335134',	'15335134',	0,	'0',	'2024-07-09 22:05:53',	'2024-07-09 21:50:28.843629',	0,	1,	0,	1,	'2300'),
(4,	1,	'DKY005',	'Device 1',	'192.168.0.10',	'Cam-15335134',	'15335134',	0,	'0',	'2024-07-09 22:06:34',	'2024-07-09 22:06:02.472515',	0,	1,	0,	1,	'2300');

DROP TABLE IF EXISTS "m_kota";
DROP SEQUENCE IF EXISTS m_kota_id_kota_seq;
CREATE SEQUENCE m_kota_id_kota_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_kota" (
    "id_kota" integer DEFAULT nextval('m_kota_id_kota_seq') NOT NULL,
    "id_provinsi" integer,
    "nama_kota" character varying(150),
    "created_date" timestamp DEFAULT CURRENT_TIMESTAMP,
    "updated_date" timestamp,
    "created_by" integer,
    "updated_by" integer,
    "deleted" smallint DEFAULT '1',
    CONSTRAINT "m_kota_pkey" PRIMARY KEY ("id_kota")
) WITH (oids = false);

INSERT INTO "m_kota" ("id_kota", "id_provinsi", "nama_kota", "created_date", "updated_date", "created_by", "updated_by", "deleted") VALUES
(1101,	11,	'KABUPATEN SIMEULUE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1102,	11,	'KABUPATEN ACEH SINGKIL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1103,	11,	'KABUPATEN ACEH SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1104,	11,	'KABUPATEN ACEH TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1105,	11,	'KABUPATEN ACEH TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1106,	11,	'KABUPATEN ACEH TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1107,	11,	'KABUPATEN ACEH BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1108,	11,	'KABUPATEN ACEH BESAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1109,	11,	'KABUPATEN PIDIE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1110,	11,	'KABUPATEN BIREUEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1111,	11,	'KABUPATEN ACEH UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1112,	11,	'KABUPATEN ACEH BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1113,	11,	'KABUPATEN GAYO LUES',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1114,	11,	'KABUPATEN ACEH TAMIANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1115,	11,	'KABUPATEN NAGAN RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1116,	11,	'KABUPATEN ACEH JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1117,	11,	'KABUPATEN BENER MERIAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1118,	11,	'KABUPATEN PIDIE JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1171,	11,	'KOTA BANDA ACEH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1172,	11,	'KOTA SABANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1173,	11,	'KOTA LANGSA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1174,	11,	'KOTA LHOKSEUMAWE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1175,	11,	'KOTA SUBULUSSALAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1201,	12,	'KABUPATEN NIAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1202,	12,	'KABUPATEN MANDAILING NATAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1203,	12,	'KABUPATEN TAPANULI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1204,	12,	'KABUPATEN TAPANULI TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1205,	12,	'KABUPATEN TAPANULI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1206,	12,	'KABUPATEN TOBA SAMOSIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1207,	12,	'KABUPATEN LABUHAN BATU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1208,	12,	'KABUPATEN ASAHAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1209,	12,	'KABUPATEN SIMALUNGUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1210,	12,	'KABUPATEN DAIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1211,	12,	'KABUPATEN KARO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1212,	12,	'KABUPATEN DELI SERDANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1213,	12,	'KABUPATEN LANGKAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1214,	12,	'KABUPATEN NIAS SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1215,	12,	'KABUPATEN HUMBANG HASUNDUTAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1216,	12,	'KABUPATEN PAKPAK BHARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1217,	12,	'KABUPATEN SAMOSIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1218,	12,	'KABUPATEN SERDANG BEDAGAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1219,	12,	'KABUPATEN BATU BARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1220,	12,	'KABUPATEN PADANG LAWAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1221,	12,	'KABUPATEN PADANG LAWAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1222,	12,	'KABUPATEN LABUHAN BATU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1223,	12,	'KABUPATEN LABUHAN BATU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1224,	12,	'KABUPATEN NIAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1225,	12,	'KABUPATEN NIAS BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1271,	12,	'KOTA SIBOLGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1272,	12,	'KOTA TANJUNG BALAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1273,	12,	'KOTA PEMATANG SIANTAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1274,	12,	'KOTA TEBING TINGGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1275,	12,	'KOTA MEDAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1276,	12,	'KOTA BINJAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1277,	12,	'KOTA PADANGSIDIMPUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1278,	12,	'KOTA GUNUNGSITOLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1301,	13,	'KABUPATEN KEPULAUAN MENTAWAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1302,	13,	'KABUPATEN PESISIR SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1303,	13,	'KABUPATEN SOLOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1304,	13,	'KABUPATEN SIJUNJUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1305,	13,	'KABUPATEN TANAH DATAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1306,	13,	'KABUPATEN PADANG PARIAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1307,	13,	'KABUPATEN AGAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1308,	13,	'KABUPATEN LIMA PULUH KOTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1309,	13,	'KABUPATEN PASAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1310,	13,	'KABUPATEN SOLOK SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1311,	13,	'KABUPATEN DHARMASRAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1312,	13,	'KABUPATEN PASAMAN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1371,	13,	'KOTA PADANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1372,	13,	'KOTA SOLOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1373,	13,	'KOTA SAWAH LUNTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1374,	13,	'KOTA PADANG PANJANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1375,	13,	'KOTA BUKITTINGGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1376,	13,	'KOTA PAYAKUMBUH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1377,	13,	'KOTA PARIAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1401,	14,	'KABUPATEN KUANTAN SINGINGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1402,	14,	'KABUPATEN INDRAGIRI HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1403,	14,	'KABUPATEN INDRAGIRI HILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1404,	14,	'KABUPATEN PELALAWAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1405,	14,	'KABUPATEN S I A K',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1406,	14,	'KABUPATEN KAMPAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1407,	14,	'KABUPATEN ROKAN HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1408,	14,	'KABUPATEN BENGKALIS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1409,	14,	'KABUPATEN ROKAN HILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1410,	14,	'KABUPATEN KEPULAUAN MERANTI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1471,	14,	'KOTA PEKANBARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1473,	14,	'KOTA D U M A I',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1501,	15,	'KABUPATEN KERINCI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1502,	15,	'KABUPATEN MERANGIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1503,	15,	'KABUPATEN SAROLANGUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1504,	15,	'KABUPATEN BATANG HARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1505,	15,	'KABUPATEN MUARO JAMBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1506,	15,	'KABUPATEN TANJUNG JABUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1507,	15,	'KABUPATEN TANJUNG JABUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1508,	15,	'KABUPATEN TEBO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1509,	15,	'KABUPATEN BUNGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1571,	15,	'KOTA JAMBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1572,	15,	'KOTA SUNGAI PENUH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1601,	16,	'KABUPATEN OGAN KOMERING ULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1602,	16,	'KABUPATEN OGAN KOMERING ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1603,	16,	'KABUPATEN MUARA ENIM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1604,	16,	'KABUPATEN LAHAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1605,	16,	'KABUPATEN MUSI RAWAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1606,	16,	'KABUPATEN MUSI BANYUASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1607,	16,	'KABUPATEN BANYU ASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1608,	16,	'KABUPATEN OGAN KOMERING ULU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1609,	16,	'KABUPATEN OGAN KOMERING ULU TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1610,	16,	'KABUPATEN OGAN ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1611,	16,	'KABUPATEN EMPAT LAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1612,	16,	'KABUPATEN PENUKAL ABAB LEMATANG ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1613,	16,	'KABUPATEN MUSI RAWAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1671,	16,	'KOTA PALEMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1672,	16,	'KOTA PRABUMULIH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1673,	16,	'KOTA PAGAR ALAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1674,	16,	'KOTA LUBUKLINGGAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1701,	17,	'KABUPATEN BENGKULU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1702,	17,	'KABUPATEN REJANG LEBONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1703,	17,	'KABUPATEN BENGKULU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1704,	17,	'KABUPATEN KAUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1705,	17,	'KABUPATEN SELUMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1706,	17,	'KABUPATEN MUKOMUKO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1707,	17,	'KABUPATEN LEBONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1708,	17,	'KABUPATEN KEPAHIANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1709,	17,	'KABUPATEN BENGKULU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1771,	17,	'KOTA BENGKULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1801,	18,	'KABUPATEN LAMPUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1802,	18,	'KABUPATEN TANGGAMUS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1803,	18,	'KABUPATEN LAMPUNG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1804,	18,	'KABUPATEN LAMPUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1805,	18,	'KABUPATEN LAMPUNG TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1806,	18,	'KABUPATEN LAMPUNG UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1807,	18,	'KABUPATEN WAY KANAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1808,	18,	'KABUPATEN TULANGBAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1809,	18,	'KABUPATEN PESAWARAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1810,	18,	'KABUPATEN PRINGSEWU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1811,	18,	'KABUPATEN MESUJI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1812,	18,	'KABUPATEN TULANG BAWANG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1813,	18,	'KABUPATEN PESISIR BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1871,	18,	'KOTA BANDAR LAMPUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1872,	18,	'KOTA METRO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1901,	19,	'KABUPATEN BANGKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1902,	19,	'KABUPATEN BELITUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1903,	19,	'KABUPATEN BANGKA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1904,	19,	'KABUPATEN BANGKA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1905,	19,	'KABUPATEN BANGKA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1906,	19,	'KABUPATEN BELITUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(1971,	19,	'KOTA PANGKAL PINANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2101,	21,	'KABUPATEN KARIMUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2102,	21,	'KABUPATEN BINTAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2103,	21,	'KABUPATEN NATUNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2104,	21,	'KABUPATEN LINGGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2105,	21,	'KABUPATEN KEPULAUAN ANAMBAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2171,	21,	'KOTA B A T A M',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(2172,	21,	'KOTA TANJUNG PINANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3101,	31,	'KABUPATEN KEPULAUAN SERIBU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3171,	31,	'KOTA JAKARTA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3172,	31,	'KOTA JAKARTA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3173,	31,	'KOTA JAKARTA PUSAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3174,	31,	'KOTA JAKARTA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3175,	31,	'KOTA JAKARTA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3201,	32,	'KABUPATEN BOGOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3202,	32,	'KABUPATEN SUKABUMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3203,	32,	'KABUPATEN CIANJUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3204,	32,	'KABUPATEN BANDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3205,	32,	'KABUPATEN GARUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3206,	32,	'KABUPATEN TASIKMALAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3207,	32,	'KABUPATEN CIAMIS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3208,	32,	'KABUPATEN KUNINGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3209,	32,	'KABUPATEN CIREBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3210,	32,	'KABUPATEN MAJALENGKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3211,	32,	'KABUPATEN SUMEDANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3212,	32,	'KABUPATEN INDRAMAYU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3213,	32,	'KABUPATEN SUBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3214,	32,	'KABUPATEN PURWAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3215,	32,	'KABUPATEN KARAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3216,	32,	'KABUPATEN BEKASI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3217,	32,	'KABUPATEN BANDUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3218,	32,	'KABUPATEN PANGANDARAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3271,	32,	'KOTA BOGOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3272,	32,	'KOTA SUKABUMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3273,	32,	'KOTA BANDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3274,	32,	'KOTA CIREBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3275,	32,	'KOTA BEKASI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3276,	32,	'KOTA DEPOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3277,	32,	'KOTA CIMAHI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3278,	32,	'KOTA TASIKMALAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3279,	32,	'KOTA BANJAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3301,	33,	'KABUPATEN CILACAP',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3302,	33,	'KABUPATEN BANYUMAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3303,	33,	'KABUPATEN PURBALINGGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3304,	33,	'KABUPATEN BANJARNEGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3305,	33,	'KABUPATEN KEBUMEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3306,	33,	'KABUPATEN PURWOREJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3307,	33,	'KABUPATEN WONOSOBO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3308,	33,	'KABUPATEN MAGELANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3309,	33,	'KABUPATEN BOYOLALI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3310,	33,	'KABUPATEN KLATEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3311,	33,	'KABUPATEN SUKOHARJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3312,	33,	'KABUPATEN WONOGIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3313,	33,	'KABUPATEN KARANGANYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3314,	33,	'KABUPATEN SRAGEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3315,	33,	'KABUPATEN GROBOGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3316,	33,	'KABUPATEN BLORA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3317,	33,	'KABUPATEN REMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3318,	33,	'KABUPATEN PATI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3319,	33,	'KABUPATEN KUDUS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3320,	33,	'KABUPATEN JEPARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3321,	33,	'KABUPATEN DEMAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3322,	33,	'KABUPATEN SEMARANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3323,	33,	'KABUPATEN TEMANGGUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3324,	33,	'KABUPATEN KENDAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3325,	33,	'KABUPATEN BATANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3326,	33,	'KABUPATEN PEKALONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3327,	33,	'KABUPATEN PEMALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3328,	33,	'KABUPATEN TEGAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3329,	33,	'KABUPATEN BREBES',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3371,	33,	'KOTA MAGELANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3372,	33,	'KOTA SURAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3373,	33,	'KOTA SALATIGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3374,	33,	'KOTA SEMARANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3375,	33,	'KOTA PEKALONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3376,	33,	'KOTA TEGAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3401,	34,	'KABUPATEN KULON PROGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3402,	34,	'KABUPATEN BANTUL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3403,	34,	'KABUPATEN GUNUNG KIDUL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3404,	34,	'KABUPATEN SLEMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3471,	34,	'KOTA YOGYAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3501,	35,	'KABUPATEN PACITAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3502,	35,	'KABUPATEN PONOROGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3503,	35,	'KABUPATEN TRENGGALEK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3504,	35,	'KABUPATEN TULUNGAGUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3505,	35,	'KABUPATEN BLITAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3506,	35,	'KABUPATEN KEDIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3507,	35,	'KABUPATEN MALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3508,	35,	'KABUPATEN LUMAJANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3509,	35,	'KABUPATEN JEMBER',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3510,	35,	'KABUPATEN BANYUWANGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3511,	35,	'KABUPATEN BONDOWOSO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3512,	35,	'KABUPATEN SITUBONDO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3513,	35,	'KABUPATEN PROBOLINGGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3514,	35,	'KABUPATEN PASURUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3515,	35,	'KABUPATEN SIDOARJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3516,	35,	'KABUPATEN MOJOKERTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3517,	35,	'KABUPATEN JOMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3518,	35,	'KABUPATEN NGANJUK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3519,	35,	'KABUPATEN MADIUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3520,	35,	'KABUPATEN MAGETAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3521,	35,	'KABUPATEN NGAWI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3522,	35,	'KABUPATEN BOJONEGORO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3523,	35,	'KABUPATEN TUBAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3524,	35,	'KABUPATEN LAMONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3525,	35,	'KABUPATEN GRESIK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3526,	35,	'KABUPATEN BANGKALAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3527,	35,	'KABUPATEN SAMPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3528,	35,	'KABUPATEN PAMEKASAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3529,	35,	'KABUPATEN SUMENEP',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3571,	35,	'KOTA KEDIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3572,	35,	'KOTA BLITAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3573,	35,	'KOTA MALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3574,	35,	'KOTA PROBOLINGGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3575,	35,	'KOTA PASURUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3576,	35,	'KOTA MOJOKERTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3577,	35,	'KOTA MADIUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3578,	35,	'KOTA SURABAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3579,	35,	'KOTA BATU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3601,	36,	'KABUPATEN PANDEGLANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3602,	36,	'KABUPATEN LEBAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3603,	36,	'KABUPATEN TANGERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3604,	36,	'KABUPATEN SERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3671,	36,	'KOTA TANGERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3672,	36,	'KOTA CILEGON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3673,	36,	'KOTA SERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(3674,	36,	'KOTA TANGERANG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5101,	51,	'KABUPATEN JEMBRANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5102,	51,	'KABUPATEN TABANAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5103,	51,	'KABUPATEN BADUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5104,	51,	'KABUPATEN GIANYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5105,	51,	'KABUPATEN KLUNGKUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5106,	51,	'KABUPATEN BANGLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5107,	51,	'KABUPATEN KARANG ASEM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5108,	51,	'KABUPATEN BULELENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5171,	51,	'KOTA DENPASAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5201,	52,	'KABUPATEN LOMBOK BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5202,	52,	'KABUPATEN LOMBOK TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5203,	52,	'KABUPATEN LOMBOK TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5204,	52,	'KABUPATEN SUMBAWA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5205,	52,	'KABUPATEN DOMPU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5206,	52,	'KABUPATEN BIMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5207,	52,	'KABUPATEN SUMBAWA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5208,	52,	'KABUPATEN LOMBOK UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5271,	52,	'KOTA MATARAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5272,	52,	'KOTA BIMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5301,	53,	'KABUPATEN SUMBA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5302,	53,	'KABUPATEN SUMBA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5303,	53,	'KABUPATEN KUPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5304,	53,	'KABUPATEN TIMOR TENGAH SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5305,	53,	'KABUPATEN TIMOR TENGAH UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5306,	53,	'KABUPATEN BELU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5307,	53,	'KABUPATEN ALOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5308,	53,	'KABUPATEN LEMBATA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5309,	53,	'KABUPATEN FLORES TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5310,	53,	'KABUPATEN SIKKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5311,	53,	'KABUPATEN ENDE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5312,	53,	'KABUPATEN NGADA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5313,	53,	'KABUPATEN MANGGARAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5314,	53,	'KABUPATEN ROTE NDAO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5315,	53,	'KABUPATEN MANGGARAI BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5316,	53,	'KABUPATEN SUMBA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5317,	53,	'KABUPATEN SUMBA BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5318,	53,	'KABUPATEN NAGEKEO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5319,	53,	'KABUPATEN MANGGARAI TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5320,	53,	'KABUPATEN SABU RAIJUA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5321,	53,	'KABUPATEN MALAKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(5371,	53,	'KOTA KUPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6101,	61,	'KABUPATEN SAMBAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6102,	61,	'KABUPATEN BENGKAYANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6103,	61,	'KABUPATEN LANDAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6104,	61,	'KABUPATEN MEMPAWAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6105,	61,	'KABUPATEN SANGGAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6106,	61,	'KABUPATEN KETAPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6107,	61,	'KABUPATEN SINTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6108,	61,	'KABUPATEN KAPUAS HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6109,	61,	'KABUPATEN SEKADAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6110,	61,	'KABUPATEN MELAWI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6111,	61,	'KABUPATEN KAYONG UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6112,	61,	'KABUPATEN KUBU RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6171,	61,	'KOTA PONTIANAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6172,	61,	'KOTA SINGKAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6201,	62,	'KABUPATEN KOTAWARINGIN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6202,	62,	'KABUPATEN KOTAWARINGIN TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6203,	62,	'KABUPATEN KAPUAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6204,	62,	'KABUPATEN BARITO SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6205,	62,	'KABUPATEN BARITO UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6206,	62,	'KABUPATEN SUKAMARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6207,	62,	'KABUPATEN LAMANDAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6208,	62,	'KABUPATEN SERUYAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6209,	62,	'KABUPATEN KATINGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6210,	62,	'KABUPATEN PULANG PISAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6211,	62,	'KABUPATEN GUNUNG MAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6212,	62,	'KABUPATEN BARITO TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6213,	62,	'KABUPATEN MURUNG RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6271,	62,	'KOTA PALANGKA RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6301,	63,	'KABUPATEN TANAH LAUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6302,	63,	'KABUPATEN KOTA BARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6303,	63,	'KABUPATEN BANJAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6304,	63,	'KABUPATEN BARITO KUALA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6305,	63,	'KABUPATEN TAPIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6306,	63,	'KABUPATEN HULU SUNGAI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6307,	63,	'KABUPATEN HULU SUNGAI TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6308,	63,	'KABUPATEN HULU SUNGAI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6309,	63,	'KABUPATEN TABALONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6310,	63,	'KABUPATEN TANAH BUMBU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6311,	63,	'KABUPATEN BALANGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6371,	63,	'KOTA BANJARMASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6372,	63,	'KOTA BANJAR BARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6401,	64,	'KABUPATEN PASER',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6402,	64,	'KABUPATEN KUTAI BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6403,	64,	'KABUPATEN KUTAI KARTANEGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6404,	64,	'KABUPATEN KUTAI TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6405,	64,	'KABUPATEN BERAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6409,	64,	'KABUPATEN PENAJAM PASER UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6411,	64,	'KABUPATEN MAHAKAM HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6471,	64,	'KOTA BALIKPAPAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6472,	64,	'KOTA SAMARINDA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6474,	64,	'KOTA BONTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6501,	65,	'KABUPATEN MALINAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6502,	65,	'KABUPATEN BULUNGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6503,	65,	'KABUPATEN TANA TIDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6504,	65,	'KABUPATEN NUNUKAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(6571,	65,	'KOTA TARAKAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7101,	71,	'KABUPATEN BOLAANG MONGONDOW',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7102,	71,	'KABUPATEN MINAHASA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7103,	71,	'KABUPATEN KEPULAUAN SANGIHE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7104,	71,	'KABUPATEN KEPULAUAN TALAUD',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7105,	71,	'KABUPATEN MINAHASA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7106,	71,	'KABUPATEN MINAHASA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7107,	71,	'KABUPATEN BOLAANG MONGONDOW UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7108,	71,	'KABUPATEN SIAU TAGULANDANG BIARO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7109,	71,	'KABUPATEN MINAHASA TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7110,	71,	'KABUPATEN BOLAANG MONGONDOW SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7111,	71,	'KABUPATEN BOLAANG MONGONDOW TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7171,	71,	'KOTA MANADO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7172,	71,	'KOTA BITUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7173,	71,	'KOTA TOMOHON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7174,	71,	'KOTA KOTAMOBAGU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7201,	72,	'KABUPATEN BANGGAI KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7202,	72,	'KABUPATEN BANGGAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7203,	72,	'KABUPATEN MOROWALI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7204,	72,	'KABUPATEN POSO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7205,	72,	'KABUPATEN DONGGALA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7206,	72,	'KABUPATEN TOLI-TOLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7207,	72,	'KABUPATEN BUOL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7208,	72,	'KABUPATEN PARIGI MOUTONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7209,	72,	'KABUPATEN TOJO UNA-UNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7210,	72,	'KABUPATEN SIGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7211,	72,	'KABUPATEN BANGGAI LAUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7212,	72,	'KABUPATEN MOROWALI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7271,	72,	'KOTA PALU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7301,	73,	'KABUPATEN KEPULAUAN SELAYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7302,	73,	'KABUPATEN BULUKUMBA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7303,	73,	'KABUPATEN BANTAENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7304,	73,	'KABUPATEN JENEPONTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7305,	73,	'KABUPATEN TAKALAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7306,	73,	'KABUPATEN GOWA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7307,	73,	'KABUPATEN SINJAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7308,	73,	'KABUPATEN MAROS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7309,	73,	'KABUPATEN PANGKAJENE DAN KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7310,	73,	'KABUPATEN BARRU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7311,	73,	'KABUPATEN BONE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7312,	73,	'KABUPATEN SOPPENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7313,	73,	'KABUPATEN WAJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7314,	73,	'KABUPATEN SIDENRENG RAPPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7315,	73,	'KABUPATEN PINRANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7316,	73,	'KABUPATEN ENREKANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7317,	73,	'KABUPATEN LUWU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7318,	73,	'KABUPATEN TANA TORAJA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7322,	73,	'KABUPATEN LUWU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7325,	73,	'KABUPATEN LUWU TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7326,	73,	'KABUPATEN TORAJA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7371,	73,	'KOTA MAKASSAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7372,	73,	'KOTA PAREPARE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7373,	73,	'KOTA PALOPO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7401,	74,	'KABUPATEN BUTON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7402,	74,	'KABUPATEN MUNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7403,	74,	'KABUPATEN KONAWE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7404,	74,	'KABUPATEN KOLAKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7405,	74,	'KABUPATEN KONAWE SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7406,	74,	'KABUPATEN BOMBANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7407,	74,	'KABUPATEN WAKATOBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7408,	74,	'KABUPATEN KOLAKA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7409,	74,	'KABUPATEN BUTON UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7410,	74,	'KABUPATEN KONAWE UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7411,	74,	'KABUPATEN KOLAKA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7412,	74,	'KABUPATEN KONAWE KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7413,	74,	'KABUPATEN MUNA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7414,	74,	'KABUPATEN BUTON TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7415,	74,	'KABUPATEN BUTON SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7471,	74,	'KOTA KENDARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7472,	74,	'KOTA BAUBAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7501,	75,	'KABUPATEN BOALEMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7502,	75,	'KABUPATEN GORONTALO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7503,	75,	'KABUPATEN POHUWATO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7504,	75,	'KABUPATEN BONE BOLANGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7505,	75,	'KABUPATEN GORONTALO UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7571,	75,	'KOTA GORONTALO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7601,	76,	'KABUPATEN MAJENE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7602,	76,	'KABUPATEN POLEWALI MANDAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7603,	76,	'KABUPATEN MAMASA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7604,	76,	'KABUPATEN MAMUJU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7605,	76,	'KABUPATEN MAMUJU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(7606,	76,	'KABUPATEN MAMUJU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8101,	81,	'KABUPATEN MALUKU TENGGARA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8102,	81,	'KABUPATEN MALUKU TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8103,	81,	'KABUPATEN MALUKU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8104,	81,	'KABUPATEN BURU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8105,	81,	'KABUPATEN KEPULAUAN ARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8106,	81,	'KABUPATEN SERAM BAGIAN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8107,	81,	'KABUPATEN SERAM BAGIAN TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8108,	81,	'KABUPATEN MALUKU BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8109,	81,	'KABUPATEN BURU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8171,	81,	'KOTA AMBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8172,	81,	'KOTA TUAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8201,	82,	'KABUPATEN HALMAHERA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8202,	82,	'KABUPATEN HALMAHERA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8203,	82,	'KABUPATEN KEPULAUAN SULA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8204,	82,	'KABUPATEN HALMAHERA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8205,	82,	'KABUPATEN HALMAHERA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8206,	82,	'KABUPATEN HALMAHERA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8207,	82,	'KABUPATEN PULAU MOROTAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8208,	82,	'KABUPATEN PULAU TALIABU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8271,	82,	'KOTA TERNATE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(8272,	82,	'KOTA TIDORE KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9101,	91,	'KABUPATEN FAKFAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9102,	91,	'KABUPATEN KAIMANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9103,	91,	'KABUPATEN TELUK WONDAMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9104,	91,	'KABUPATEN TELUK BINTUNI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9105,	91,	'KABUPATEN MANOKWARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9106,	91,	'KABUPATEN SORONG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9107,	91,	'KABUPATEN SORONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9108,	91,	'KABUPATEN RAJA AMPAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9109,	91,	'KABUPATEN TAMBRAUW',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9110,	91,	'KABUPATEN MAYBRAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9111,	91,	'KABUPATEN MANOKWARI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9112,	91,	'KABUPATEN PEGUNUNGAN ARFAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9171,	91,	'KOTA SORONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9401,	94,	'KABUPATEN MERAUKE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9402,	94,	'KABUPATEN JAYAWIJAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9403,	94,	'KABUPATEN JAYAPURA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9404,	94,	'KABUPATEN NABIRE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9408,	94,	'KABUPATEN KEPULAUAN YAPEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9409,	94,	'KABUPATEN BIAK NUMFOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9410,	94,	'KABUPATEN PANIAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9411,	94,	'KABUPATEN PUNCAK JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9412,	94,	'KABUPATEN MIMIKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9413,	94,	'KABUPATEN BOVEN DIGOEL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9414,	94,	'KABUPATEN MAPPI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9415,	94,	'KABUPATEN ASMAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9416,	94,	'KABUPATEN YAHUKIMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9417,	94,	'KABUPATEN PEGUNUNGAN BINTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9418,	94,	'KABUPATEN TOLIKARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9419,	94,	'KABUPATEN SARMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9420,	94,	'KABUPATEN KEEROM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9426,	94,	'KABUPATEN WAROPEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9427,	94,	'KABUPATEN SUPIORI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9428,	94,	'KABUPATEN MAMBERAMO RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9429,	94,	'KABUPATEN NDUGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9430,	94,	'KABUPATEN LANNY JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9431,	94,	'KABUPATEN MAMBERAMO TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9432,	94,	'KABUPATEN YALIMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9433,	94,	'KABUPATEN PUNCAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9434,	94,	'KABUPATEN DOGIYAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9435,	94,	'KABUPATEN INTAN JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9436,	94,	'KABUPATEN DEIYAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9471,	94,	'KOTA JAYAPURA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1),
(9472,	81,	'KABUPATEN MALUKU BARAT DAYA',	'2017-06-15 16:12:17',	'2017-06-15 23:21:29',	1,	1,	1);

DROP TABLE IF EXISTS "m_outlet";
DROP SEQUENCE IF EXISTS m_outlet_id_outlet_seq;
CREATE SEQUENCE m_outlet_id_outlet_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_outlet" (
    "id_outlet" integer DEFAULT nextval('m_outlet_id_outlet_seq') NOT NULL,
    "nama_outlet" character varying(150),
    "kode_outlet" character varying(150),
    "key_outlet" text,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "created_by" integer,
    CONSTRAINT "m_outlet_pkey" PRIMARY KEY ("id_outlet")
) WITH (oids = false);


DROP TABLE IF EXISTS "m_provinsi";
DROP SEQUENCE IF EXISTS m_provinsi_id_provinsi_seq;
CREATE SEQUENCE m_provinsi_id_provinsi_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_provinsi" (
    "id_provinsi" integer DEFAULT nextval('m_provinsi_id_provinsi_seq') NOT NULL,
    "nama_provinsi" character varying(150),
    "created_date" timestamp DEFAULT CURRENT_TIMESTAMP,
    "updated_date" timestamp,
    "created_by" integer,
    "updated_by" integer,
    "deleted" smallint DEFAULT '1',
    CONSTRAINT "m_provinsi_pkey" PRIMARY KEY ("id_provinsi")
) WITH (oids = false);

INSERT INTO "m_provinsi" ("id_provinsi", "nama_provinsi", "created_date", "updated_date", "created_by", "updated_by", "deleted") VALUES
(11,	'ACEH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(12,	'SUMATERA UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(13,	'SUMATERA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(14,	'RIAU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(15,	'JAMBI',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(16,	'SUMATERA SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(17,	'BENGKULU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(18,	'LAMPUNG',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(19,	'KEPULAUAN BANGKA BELITUNG',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(21,	'KEPULAUAN RIAU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(31,	'DKI JAKARTA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(32,	'JAWA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(33,	'JAWA TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(34,	'DI YOGYAKARTA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(35,	'JAWA TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(36,	'BANTEN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(51,	'BALI',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(52,	'NUSA TENGGARA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(53,	'NUSA TENGGARA TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(61,	'KALIMANTAN BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(62,	'KALIMANTAN TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(63,	'KALIMANTAN SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(64,	'KALIMANTAN TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(65,	'KALIMANTAN UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(71,	'SULAWESI UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(72,	'SULAWESI TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(73,	'SULAWESI SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(74,	'SULAWESI TENGGARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(75,	'GORONTALO',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(76,	'SULAWESI BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(81,	'MALUKU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(82,	'MALUKU UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(91,	'PAPUA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1),
(94,	'PAPUA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1);

DROP TABLE IF EXISTS "m_setting";
DROP SEQUENCE IF EXISTS m_setting_id_seq;
CREATE SEQUENCE m_setting_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_setting" (
    "id" integer DEFAULT nextval('m_setting_id_seq') NOT NULL,
    "name" character varying(200),
    "code" character varying(200),
    "value" character varying(255),
    CONSTRAINT "m_setting_pkey" PRIMARY KEY ("id")
) WITH (oids = false);

INSERT INTO "m_setting" ("id", "name", "code", "value") VALUES
(1,	'Last Id Migration',	'last_id_migration',	'3290482');

DROP TABLE IF EXISTS "m_site";
DROP SEQUENCE IF EXISTS m_site_site_id_seq;
CREATE SEQUENCE m_site_site_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_site" (
    "site_id" integer DEFAULT nextval('m_site_site_id_seq') NOT NULL,
    "sitename" character varying(255),
    "site_code" character varying(150),
    "divison_id" character varying(50),
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "key_outlet" character varying,
    "deleted" smallint DEFAULT '1',
    "id_provinsi" integer,
    "id_kota" integer,
    "from_migration" integer,
    "location_id" character varying(150),
    "store_availibility" integer DEFAULT '1',
    CONSTRAINT "m_site_pkey" PRIMARY KEY ("site_id")
) WITH (oids = false);

INSERT INTO "m_site" ("site_id", "sitename", "site_code", "divison_id", "created_at", "key_outlet", "deleted", "id_provinsi", "id_kota", "from_migration", "location_id", "store_availibility") VALUES
(1,	'Diky Shoes',	'DKY003',	'01',	'2024-07-01 10:23:53.990967',	'uD8jVBQB3ZIvs89iPHPnOk4jYrhhNFY2iJrDK1PDBVU=',	1,	11,	1101,	0,	'0',	1),
(3,	'test4',	'tst',	'01',	'2024-07-05 07:14:02.020181',	NULL,	0,	17,	1701,	NULL,	'01',	1),
(2,	'Diky Shirt',	'DKY001',	'01',	'2024-07-01 11:08:22.342518',	'yQebkCbsmgi26E4TxOcESU4jYrhhNFY2iJrDK1PDBVU=',	1,	11,	1101,	0,	'0',	2),
(4,	'Diky Shoes 1',	'DKY005',	'LB',	'2024-07-09 20:57:18.089012',	'',	1,	NULL,	NULL,	NULL,	NULL,	1);

DROP TABLE IF EXISTS "m_user";
DROP SEQUENCE IF EXISTS m_user_id_user_seq;
CREATE SEQUENCE m_user_id_user_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."m_user" (
    "id_user" integer DEFAULT nextval('m_user_id_user_seq') NOT NULL,
    "username" character varying,
    "password" text,
    "id_level" smallint,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "created_by" integer,
    "deleted" smallint DEFAULT '1',
    "list_site" text,
    "list_brand" text,
    "name" character varying(200),
    CONSTRAINT "m_user_pkey" PRIMARY KEY ("id_user")
) WITH (oids = false);

INSERT INTO "m_user" ("id_user", "username", "password", "id_level", "created_at", "created_by", "deleted", "list_site", "list_brand", "name") VALUES
(1,	'admin',	'MTIzNDU=',	1,	'2024-06-05 11:05:22.287275',	1,	1,	NULL,	NULL,	NULL),
(2038,	'adminsensorindo',	'YWRtaW4=',	2,	'2024-06-05 11:05:22.289135',	1,	1,	NULL,	NULL,	'adminsensorindo'),
(2039,	'oza',	'b3ph',	4,	'2024-06-05 11:05:22.28941',	1,	1,	'3,1',	'2,3',	'oza');

DROP TABLE IF EXISTS "map_site_brand";
DROP SEQUENCE IF EXISTS map_site_brand_id_seq;
CREATE SEQUENCE map_site_brand_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."map_site_brand" (
    "id" integer DEFAULT nextval('map_site_brand_id_seq') NOT NULL,
    "id_brand" integer NOT NULL,
    "id_site" integer NOT NULL,
    CONSTRAINT "map_site_brand_pkey" PRIMARY KEY ("id")
) WITH (oids = false);

INSERT INTO "map_site_brand" ("id", "id_brand", "id_site") VALUES
(1,	1,	1),
(3,	1,	2);

DROP TABLE IF EXISTS "map_user_site_brand";
DROP SEQUENCE IF EXISTS map_user_site_brand_id_seq;
CREATE SEQUENCE map_user_site_brand_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."map_user_site_brand" (
    "id" integer DEFAULT nextval('map_user_site_brand_id_seq') NOT NULL,
    "id_user" integer,
    "id_brand" integer,
    "list_site" text,
    "id_provinsi" integer,
    CONSTRAINT "map_user_site_brand_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "people_count_log";
DROP SEQUENCE IF EXISTS people_count_log_id_temp_seq;
CREATE SEQUENCE people_count_log_id_temp_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."people_count_log" (
    "id_temp" integer DEFAULT nextval('people_count_log_id_temp_seq') NOT NULL,
    "_id" character varying(250),
    "site" character varying(150),
    "site_name" character varying(150),
    "device_id" character varying(150),
    "device_name" character varying(150),
    "division_id" character varying(150),
    "id" character varying(50),
    "object_type" character varying(50),
    "name" character varying(150),
    "start_time" timestamp,
    "end_time" timestamp,
    "unix_start_time" character varying(50),
    "enters" character varying(50),
    "exits" character varying(50),
    "status" character varying(50),
    "created_time" timestamp,
    "prev_camera" text,
    "__v" integer,
    "migration_number" smallint,
    CONSTRAINT "people_count_log_pkey" PRIMARY KEY ("id_temp")
) WITH (oids = false);


DROP TABLE IF EXISTS "people_count_log_daily";
CREATE TABLE "public"."people_count_log_daily" (
    "_id" character varying(250) NOT NULL,
    "__v" integer,
    "device_id" character varying(150),
    "device_name" character varying(150),
    "enters" character varying(50),
    "exits" character varying(50),
    "hourly" text,
    "site" character varying(150),
    "site_name" character varying(150),
    "start_time" timestamp
) WITH (oids = false);


DROP TABLE IF EXISTS "t_backup_data";
DROP SEQUENCE IF EXISTS t_backup_data_id_seq;
CREATE SEQUENCE t_backup_data_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_backup_data" (
    "id" integer DEFAULT nextval('t_backup_data_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "start_time" timestamp,
    "end_time" timestamp,
    "enter" integer,
    "exit" integer,
    "status" smallint,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "from_migration" integer,
    CONSTRAINT "t_backup_data_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_daily";
DROP SEQUENCE IF EXISTS t_count_daily_id_seq;
CREATE SEQUENCE t_count_daily_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_daily" (
    "id" integer DEFAULT nextval('t_count_daily_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "enter" integer,
    "exit" integer,
    "report_date" date,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT "t_count_daily_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_monthly";
DROP SEQUENCE IF EXISTS t_count_monthly_id_seq;
CREATE SEQUENCE t_count_monthly_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_monthly" (
    "id" integer DEFAULT nextval('t_count_monthly_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "enter" integer,
    "exit" integer,
    "month" integer,
    "year" integer,
    CONSTRAINT "t_count_monthly_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_people";
DROP SEQUENCE IF EXISTS t_count_people_id_seq;
CREATE SEQUENCE t_count_people_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_people" (
    "id" integer DEFAULT nextval('t_count_people_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "start_time" timestamp,
    "end_time" timestamp,
    "enter" integer,
    "exit" integer,
    "status" smallint,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "from_migration" integer,
    CONSTRAINT "t_count_people_pkey" PRIMARY KEY ("id")
) WITH (oids = false);

INSERT INTO "t_count_people" ("id", "site_id", "site_name", "device_id", "device_name", "start_time", "end_time", "enter", "exit", "status", "created_at", "from_migration") VALUES
(1,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 11:00:00',	'2024-07-03 12:00:00',	10,	15,	0,	'2024-07-03 17:06:53.493335',	0),
(2,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 12:00:00',	'2024-07-03 13:00:00',	51,	21,	0,	'2024-07-03 17:06:53.493335',	0),
(3,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 13:00:00',	'2024-07-03 14:00:00',	97,	99,	0,	'2024-07-03 17:06:53.493335',	0),
(4,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 14:00:00',	'2024-07-03 15:00:00',	21,	43,	0,	'2024-07-03 17:06:53.493335',	0),
(5,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 15:00:00',	'2024-07-03 16:00:00',	42,	12,	0,	'2024-07-03 17:06:53.493335',	0),
(6,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 16:00:00',	'2024-07-03 17:00:00',	34,	65,	0,	'2024-07-03 17:06:53.493335',	0),
(7,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 17:00:00',	'2024-07-03 18:00:00',	31,	51,	0,	'2024-07-03 17:06:53.493335',	0),
(8,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 18:00:00',	'2024-07-03 19:00:00',	76,	12,	0,	'2024-07-03 17:06:53.493335',	0),
(9,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 19:00:00',	'2024-07-03 20:00:00',	54,	31,	0,	'2024-07-03 17:06:53.493335',	0),
(10,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 21:00:00',	'2024-07-03 22:00:00',	14,	53,	0,	'2024-07-03 17:06:53.493335',	0),
(11,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 22:00:00',	'2024-07-03 23:00:00',	5,	7,	0,	'2024-07-03 17:06:53.493335',	0),
(12,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 11:00:00',	'2024-07-04 12:00:00',	42,	12,	0,	'2024-07-04 17:06:53.493335',	0),
(13,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 12:00:00',	'2024-07-04 13:00:00',	12,	23,	0,	'2024-07-04 17:06:53.493335',	0),
(14,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 13:00:00',	'2024-07-04 14:00:00',	34,	65,	0,	'2024-07-04 17:06:53.493335',	0),
(15,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 14:00:00',	'2024-07-04 15:00:00',	32,	56,	0,	'2024-07-04 17:06:53.493335',	0),
(16,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 15:00:00',	'2024-07-04 16:00:00',	76,	34,	0,	'2024-07-04 17:06:53.493335',	0),
(17,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 16:00:00',	'2024-07-04 17:00:00',	45,	23,	0,	'2024-07-04 17:06:53.493335',	0),
(18,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 17:00:00',	'2024-07-04 18:00:00',	34,	12,	0,	'2024-07-04 17:06:53.493335',	0),
(19,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 18:00:00',	'2024-07-04 19:00:00',	45,	12,	0,	'2024-07-04 17:06:53.493335',	0),
(20,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 19:00:00',	'2024-07-04 20:00:00',	64,	64,	0,	'2024-07-04 17:06:53.493335',	0),
(21,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 21:00:00',	'2024-07-04 22:00:00',	24,	12,	0,	'2024-07-04 17:06:53.493335',	0),
(22,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 22:00:00',	'2024-07-04 23:00:00',	12,	7,	0,	'2024-07-04 17:06:53.493335',	0),
(23,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 11:00:00',	'2024-07-05 12:00:00',	76,	31,	0,	'2024-07-05 17:06:53.493335',	0),
(24,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 12:00:00',	'2024-07-05 13:00:00',	34,	52,	0,	'2024-07-05 17:06:53.493335',	0),
(25,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 13:00:00',	'2024-07-05 14:00:00',	13,	52,	0,	'2024-07-05 17:06:53.493335',	0),
(26,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 14:00:00',	'2024-07-05 15:00:00',	54,	34,	0,	'2024-07-05 17:06:53.493335',	0),
(27,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 15:00:00',	'2024-07-05 16:00:00',	92,	56,	0,	'2024-07-05 17:06:53.493335',	0),
(28,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 16:00:00',	'2024-07-05 17:00:00',	71,	95,	0,	'2024-07-05 17:06:53.493335',	0),
(29,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 17:00:00',	'2024-07-05 18:00:00',	23,	54,	0,	'2024-07-05 17:06:53.493335',	0),
(30,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 18:00:00',	'2024-07-05 19:00:00',	42,	62,	0,	'2024-07-05 17:06:53.493335',	0),
(31,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 19:00:00',	'2024-07-05 20:00:00',	42,	13,	0,	'2024-07-05 17:06:53.493335',	0),
(32,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 21:00:00',	'2024-07-05 22:00:00',	12,	12,	0,	'2024-07-05 17:06:53.493335',	0),
(33,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 22:00:00',	'2024-07-05 23:00:00',	7,	7,	0,	'2024-07-05 17:06:53.493335',	0),
(34,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-03 10:00:00',	'2024-07-03 11:00:00',	21,	23,	0,	'2024-07-03 17:06:53.493335',	0),
(35,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-04 10:00:00',	'2024-07-04 11:00:00',	32,	43,	0,	'2024-07-04 17:06:53.493335',	0),
(36,	1,	'Diky Shoes',	1,	'Device 1',	'2024-07-05 10:00:00',	'2024-07-05 11:00:00',	23,	56,	0,	'2024-07-05 17:06:53.493335',	0),
(37,	4,	'Diky Shoes 1',	3,	'Device 1',	'2024-01-18 00:00:00',	'2024-01-18 01:00:00',	0,	0,	0,	'2024-07-09 22:05:53.884211',	NULL),
(38,	1,	'Diky Shoes 1',	4,	'Device 1',	'2024-01-18 00:00:00',	'2024-01-18 01:00:00',	0,	0,	0,	'2024-07-09 22:06:02.474368',	NULL),
(39,	1,	'Diky Shoes 1',	4,	'Device 1',	'2024-01-18 09:00:00',	'2024-01-18 10:00:00',	10,	5,	0,	'2024-07-09 22:06:34.25298',	NULL);

DROP TABLE IF EXISTS "t_count_people_dev";
DROP SEQUENCE IF EXISTS t_count_people_dev_id_seq;
CREATE SEQUENCE t_count_people_dev_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_people_dev" (
    "id" integer DEFAULT nextval('t_count_people_dev_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "start_time" timestamp,
    "end_time" timestamp,
    "enter" integer,
    "exit" integer,
    "status" smallint,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    "from_migration" integer,
    CONSTRAINT "t_count_people_dev_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_people_standard";
DROP SEQUENCE IF EXISTS t_count_people_standard_id_seq;
CREATE SEQUENCE t_count_people_standard_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_people_standard" (
    "id" integer DEFAULT nextval('t_count_people_standard_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "start_time" timestamp,
    "end_time" timestamp,
    "enter" integer,
    "exit" integer,
    "status" smallint,
    "created_at" timestamp DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT "t_count_people_standard_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_weekly";
DROP SEQUENCE IF EXISTS t_count_weekly_id_seq;
CREATE SEQUENCE t_count_weekly_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_weekly" (
    "id" integer DEFAULT nextval('t_count_weekly_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "enter" integer,
    "exit" integer,
    "week" integer,
    "month" integer,
    "year" integer,
    CONSTRAINT "t_count_weekly_pkey" PRIMARY KEY ("id")
) WITH (oids = false);


DROP TABLE IF EXISTS "t_count_yearly";
DROP SEQUENCE IF EXISTS t_count_yearly_id_seq;
CREATE SEQUENCE t_count_yearly_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;

CREATE TABLE "public"."t_count_yearly" (
    "id" integer DEFAULT nextval('t_count_yearly_id_seq') NOT NULL,
    "site_id" integer,
    "site_name" character varying(255),
    "device_id" integer,
    "device_name" character varying(250),
    "enter" integer,
    "exit" integer,
    "year" integer,
    CONSTRAINT "t_count_yearly_pkey" PRIMARY KEY ("id")
) WITH (oids = false);
