<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Http\Traits\CreatedUpdatedBy;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    //const CREATED_AT = 'created_date';
    //const UPDATED_AT = 'updated_date';
    protected $table = "users";
    protected $primaryKey = 'id';
    protected $rememberTokenName = false;
    protected $fillable = [
        'name', 'email', 'password', 'db_host', 'db_port', 'db_database', 'db_username', 'db_password', 'id_level', 'list_site', 'list_brand','bussiness_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password'
    ];

    public static function withDeleted()
    {
        return self::where('deleted',1);
    }
    public static function updateDeleted($id)
    {
        return self::find($id)->update(['deleted'=>0]);
    }
    public static function getUserById($user_id){
        return self::where('deleted',1)->where('id',$user_id);
    }

    public function selectDataTables($id_user, $username, $start, $length, $search, $sort, $sort_direction){
        $query = self::where('deleted',1)->where('id_level','>',2);
        if ($search != null && $search !='')
        {
            $query->where('email','like','%'.$search.'%');
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != '')
        {
            $query->orderBy($sort,$sort_direction);
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query->offset($start)->limit($length);
        }
        return $query;
    }

    public function TotalDataV1($search){
        $query = self::where('deleted',1)->where('id_level','>',2);
        if ($search != null && $search !='')
        {
            $query->where('email','like','%'.$search.'%');
        }
        return $query->count();
    }

    public function selectUSB($id_user){
        $query = DB::table('map_user_site_brand')->where('id_user',$id_user);
        return $query;
    }

    public function insert_q($arr_data){
        $id = DB::table('users')->insertGetId($arr_data, 'id');
        return $id;
    }

    public static function update_q($id,$arr_data){
        DB::table('users')->where('id', $id)->update($arr_data);
        return true;
    }

    public static function delete_q($id){
        DB::table('users')->where('id', $id)->update(['deleted'=>0]);
        return true;
    }

    public function insertMapUSB($arr_data){
        $id = DB::table('map_user_site_brand')->insertGetId($arr_data, 'id');
        return $id;
    }

    public function deleteMapUSB($id){
        DB::table('map_user_site_brand')->where('id_user',$id)->delete();
        return true;
    }

    public function cekDuplicate($id_user, $username){
        $query = self::where('deleted',1)->where('email','like',$username);
        if($id_user != 0){
            $query->where('id','!=',$id_user);
        }
        return $query;
    }
    
}
