<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class MDevice extends Model
{
    use HasFactory;

    protected $table = "m_device";
    protected $primaryKey = 'device_id';
    public $timestamps = false;
    protected $fillable = [
    ];
    public static function checkExist($id)
    {
        return self::where('device_id',$id);
    }

    public static function selectDataTables($device_id,$device_code, $start, $length, $search, $sort, $sort_direction){
        $query = "SELECT m_device.*, m_site.sitename as site_name,m_site.site_code from m_device left join m_site on m_site.site_id = m_device.site_id where m_device.deleted = 1 and m_site.deleted = 1";
        if ($device_id != 0)
        {
            $query .= " and m_device.device_id = ".$device_id;
        }
        if($device_code != '' && $device_code != null){
            $query .= " and m_device.device_code = ".$device_code;
        }
        //dd($search);
        if ($search != null && $search !='')
        {
            $query .= " AND (m_device.device_code LIKE '%".$search."%' or m_device.device_name LIKE '%".$search."%' or m_device.ip_address LIKE '%".$search."%' or m_site.sitename LIKE '%".$search."%')";
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != '')
        {
            $query .= " ORDER BY " . $sort . " " . $sort_direction;
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query .= " LIMIT " . $length;
            $query .= " OFFSET " . $start;
            
        }
        return DB::select($query);
    }

    public static function selectDataTablesV2($device_id,$device_code,$site_id, $start, $length, $search, $sort, $sort_direction){
        $query = DB::table('m_device')
                    ->leftJoin('m_site', 'm_site.site_id', '=', 'm_device.site_id')
                    ->where('m_device.deleted',1)
                    ->where('m_site.deleted',1)
                    ->whereIn('m_device.site_id',$site_id);
        if ($device_id != 0)
        {
            $query->where('m_device.device_id', $device_code);
        }
        if($device_code != '' && $device_code != null){
            $query->where('m_device.device_code', $device_code);
        }
        //dd($search);
        if ($search != null && $search !='')
        {
            $query->where(function (Builder $qu) {
                $qu->where('m_device.device_code', 'like', '%'.$search.'%')
                    ->orWhere('m_device.device_name', 'like', '%'.$search.'%')
                    ->orWhere('m_device.ip_address', 'like', '%'.$search.'%')
                    ->orWhere('m_site.sitename', 'like', '%'.$search.'%');
            });
            //$query->where('m_device.device_code', 'like', '%'.$search.'%');
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != '')
        {
            $query->orderBy($sort,$sort_direction);
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query->offset($start)->limit($length);
        }
        return $query;
    }

    public static function TotalDataV1($search){
        $query = "SELECT count(m_device.device_id) from m_device left join m_site on m_site.site_id = m_device.site_id where m_device.deleted = 1 and m_site.deleted = 1";
        if ($search != null && $search !='')
        {
            $query .= " AND (m_device.device_code LIKE '%".$search."%' or m_device.device_name LIKE '%".$search."%' or m_device.ip_address LIKE '%".$search."%' or m_site.sitename LIKE '%".$search."%')";
        }
        return DB::select($query);
    }

    public static function TotalDataV2($site_id,$search){
        $query = DB::table('m_device')
                    ->leftJoin('m_site', 'm_site.site_id', '=', 'm_device.site_id')
                    ->where('m_device.deleted',1)
                    ->where('m_site.deleted',1)
                    ->whereIn('m_device.site_id',$site_id);
        if ($search != null && $search !='')
        {
            $query->where(function (Builder $qu) {
                $qu->where('m_device.device_code', 'like', '%'.$search.'%')
                    ->orWhere('m_device.device_name', 'like', '%'.$search.'%')
                    ->orWhere('m_device.ip_address', 'like', '%'.$search.'%')
                    ->orWhere('m_site.sitename', 'like', '%'.$search.'%');
            });
            //$query->where('m_device.device_code', 'like', '%'.$search.'%');
        }
        return $query->count();
    }

    public static function selectCameraOffv1($device_id,$device_code){
        $query = "SELECT m_device.*, m_site.sitename as site_name,m_site.site_code from m_device left join m_site on m_site.site_id = m_device.site_id where m_device.deleted = 1 and m_device.status in (1,2,3,4,6) and m_site.deleted = 1";
        if($device_id != 0){
            $query .= " and m_device.device_id = ".$device_id;
        }
        if($device_code != '' && $device_code != null){
            $query .= " and m_device.device_code = ".$device_code;
        }
        return DB::select($query);
    }

    public static function selectCameraOff($device_id,$device_code,$site_id){
        $query = DB::table('m_device')
                    ->leftJoin('m_site', 'm_site.site_id', '=', 'm_device.site_id')
                    ->where('m_device.deleted',1)
                    ->where('m_site.deleted',1)
                    ->whereIn('m_device.site_id',$site_id)
                    ->whereIn('m_device.status',[1,2,3,4,6]);
        if ($device_id != 0)
        {
            $query->where('m_device.device_id', $device_code);
        }
        if($device_code != '' && $device_code != null){
            $query->where('m_device.device_code', $device_code);
        }
        return $query;
    }

    public static function select_q($device_id,$device_code,$site_id){
        $query = DB::table('m_device')
                    ->where('m_device.deleted',1);
        if ($device_id != 0)
        {
            $query->where('m_device.device_id', $device_id);
        }
        if($device_code != '' && $device_code != null){
            $query->where('m_device.device_code', $device_code);
        }
        if ($site_id != 0)
        {
            $query->where('m_device.site_id', $site_id);
        }
        return $query;
    }

    public static function insert_q($arr_data){
        $id = DB::table('m_device')->insertGetId($arr_data, 'device_id');
        return $id;
    }

    public static function update_q($id,$arr_data){
        DB::table('m_device')->where('device_id', $id)->update($arr_data);
        return true;
    }

    public static function updateStatus($device_id,$status,$end_date,$ip_address){
        DB::table('m_device')->where('device_id', $device_id)->update(['status'=>$status,'last_report'=>$end_date,'ip_address'=>$ip_address]);
        return true;
    }

    public static function TotalData($device_code){
        $query = DB::DB('m_device')->select('device_id');
        if($device_code != '' && $device_code != null){
            $query->where('m_device.device_code', $device_code);
        }
        return $query->count();
    }

    public static function delete_q($id){
        DB::table('m_device')->where('device_id', $id)->update(['deleted'=>0]);
        return true;
    }

    public static function updateCameraOffline($last_report,$status,$device_id){
        DB::table('m_device')->whereIn('device_id', $device_id)->update(['status'=>$status,'last_report'=>$last_report]);
        return true;
    }

    public static function getCameraExist(){
        $query = DB::table('m_device')
                    ->select('device_id','last_report','status','deleted','status_record')
                    ->whereIn('status',[0,5])
                    ->where('deleted',1);
        return $query;
    }

    public static function selectBySite($site_id){
        $query = DB::table('m_device')
                    ->select('m_device.*','m_site.sitename as site_name')
                    ->join('m_site', 'm_site.site_id', '=', 'm_device.site_id')
                    ->where('m_device.deleted',1)
                    ->where('m_device.status_record',1)
                    ->where('m_site.deleted',1)
                    ->whereIn('m_device.site_id',$site_id)
                    ->orderBy('m_site.site_id', 'asc')
                    ->orderBy('m_device.device_id', 'asc');
        return $query;
    }
    
    public static function select_detail($device_id,$device_code){
        $query = DB::table('m_device')
                    ->join('m_site','m_device.site_id','=','m_site.site_id')
                    ->where('m_device.deleted',1);
        if ($device_id != 0)
        {
            $query->where('m_device.device_id', $device_id);
        }
        if($device_code != '' && $device_code != null){
            $query->where('m_device.device_code', $device_code);
        }
        return $query;
    }

    public static function checkExistByName($device_name)
    {
        return self::where('device_name',$device_name);
    }
}
