<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class MCountPeople extends Model
{
    use HasFactory;

    protected $table = "t_count_people";
    protected $primaryKey = 'id';
    public $timestamps = false;
    protected $fillable = [
    ];
    public static function checkExist($id)
    {
        return self::where('id',$id);
    }

    public static function SelectTotalDataDashboardV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id);
        return $query;
    }
    public static function SelectDailyLocationDashboardV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select('t_count_people.site_id','t_count_people.site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupBy('t_count_people.site_id','t_count_people.site_name');
        return $query;
    }

    public static function SelectMonthlyTrendV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw('CAST(start_time AS DATE) as date'),DB::raw("date_part('day',start_time) as day"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),date_part('day',start_time)")
                    ->orderByRaw('CAST(start_time AS DATE)');
        return $query;
        
    }
    public static function SelectDailyTrendv3($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('hour', start_time) AS hour"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('hour', start_time)")
                    ->orderByRaw("date_part('hour', start_time)");
        return $query;
        
    }

    public static function SelectWeeklyTrendV3($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("EXTRACT(MONTH FROM start_time) AS Month"),DB::raw("date_part('week', start_time)- date_part('week', date_trunc('month', start_time))+ 1 AS week"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('week', start_time) - date_part('week', date_trunc('month', start_time))+ 1 , EXTRACT(MONTH FROM start_time)")
                    ->orderByRaw("EXTRACT(MONTH FROM start_time), date_part('week', start_time) - date_part('week', date_trunc('month', start_time))+ 1");
        return $query;
        
    }
    public static function SelectYearlyTrendV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("EXTRACT(YEAR FROM start_time) as year"),DB::raw('EXTRACT(MONTH FROM start_time) AS monthNumber'),DB::raw("to_char(start_time, 'Month') as month"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("EXTRACT(YEAR FROM start_time),EXTRACT(MONTH FROM start_time),to_char(start_time, 'Month')")
                    ->orderByRaw('EXTRACT(YEAR FROM start_time),EXTRACT(MONTH FROM start_time)');
        return $query;
        
    }

    public static function SelectPeopleCountDeviceV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select('m_site.site_id','m_site.site_code','m_device.device_code','t_count_people.site_name','t_count_people.device_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupBy('t_count_people.site_name','t_count_people.device_name','m_site.site_code','m_device.device_code','m_site.site_id')
                    ->orderBy('m_site.site_id');
        return $query;
        
    }

    public static function SelectTDHourlyV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('hour', start_time) AS hour"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('hour', start_time),t_count_people.site_id,m_site.sitename")
                    // ->orderBy('t_count_people.site_id');
                    ->orderBy('hour');
        return $query;
        
    }

    public static function SelectTDHourlyTotalV2($start_date,$end_date,$site_id,$device_id){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('hour', start_time) AS hour"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('hour', start_time)")
                    ->orderBy('hour');
        return $query;
        
    }

    public static function SelectTDWeeklyV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select('t_count_people.site_id','m_site.sitename as site_name',DB::raw("CAST(start_time AS DATE) as date"),DB::raw("to_char(start_time, 'Day') as day"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),to_char(start_time, 'Day'),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw('CAST(start_time AS DATE)');
        return $query;
        
    }

    public static function SelectTDWeeklyTotalV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("CAST(start_time AS DATE) as date"),DB::raw("to_char(start_time, 'Day') as day"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),to_char(start_time, 'Day')")
                    ->orderByRaw('CAST(start_time AS DATE)');
        return $query;
        
    }

    public static function SelectTDMonthlyV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select('t_count_people.site_id','m_site.sitename as site_name',DB::raw("CAST(start_time AS DATE) as date"),DB::raw("to_char(start_time, 'DD Mon YY') AS day"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),to_char(start_time, 'DD Mon YY'),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw('CAST(start_time AS DATE)');
        return $query;
        
    }

    public static function SelectTDMonthlyTotalV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("CAST(start_time AS DATE) as date"),DB::raw("to_char(start_time, 'DD Mon YY') AS day"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),to_char(start_time, 'DD Mon YY')")
                    ->orderByRaw('CAST(start_time AS DATE)');
        return $query;
        
    }

    public static function SelectTDYearlyV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('year', start_time) AS year"),DB::raw("date_part('month', start_time) AS month"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('year', start_time),date_part('month', start_time),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("date_part('year', start_time),date_part('month', start_time)");
        return $query;
        
    }

    public static function SelectTDYearlyTotalV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('year', start_time) AS year"),DB::raw("date_part('month', start_time) AS month"),DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('year', start_time),date_part('month', start_time)")
                    ->orderByRaw("date_part('year', start_time),date_part('month', start_time)");
        return $query;
        
    }

    public static function SelectDRHourlyV3($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('hour', start_time) AS hour"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('hour', start_time),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("date_part('hour', start_time)");
        return $query;
        
    }

    public static function SelectDRDailyV3($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("CAST(start_time AS DATE) as day"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("CAST(start_time AS DATE),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("CAST(start_time AS DATE),t_count_people.site_id");
        return $query;
        
    }

    //SelectDRWeeklyV3
    public static function SelectDRWeeklyV3($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("EXTRACT(MONTH FROM start_time) AS month"),DB::raw("date_part('week', start_time)- date_part('week', date_trunc('month', start_time))+ 1 AS week"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('week', start_time)- date_part('week', date_trunc('month', start_time))+ 1,EXTRACT(MONTH FROM start_time),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("EXTRACT(MONTH FROM start_time),date_part('week', start_time)- date_part('week', date_trunc('month', start_time))+ 1,t_count_people.site_id");
        return $query;
        
    }

    public static function SelectDRMonthlyV3($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('year', start_time) AS year"),DB::raw("date_part('month', start_time) AS month"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('year', start_time),date_part('month', start_time),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("date_part('year', start_time),date_part('month', start_time),t_count_people.site_id");
        return $query;
        
    }
    public static function SelectDRYearlyV3($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("date_part('year', start_time) AS year"),'t_count_people.site_id','m_site.sitename as site_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("date_part('year', start_time),t_count_people.site_id,m_site.sitename")
                    ->orderByRaw("date_part('year', start_time),t_count_people.site_id");
        return $query;
        
    }
    //SelectDRCustomHV2
    public static function SelectDRCustomHV2($start_date,$end_date,$site_id,$device_id,$start_time,$end_param){
        $query = DB::table('t_count_people')
                    ->select(DB::raw("to_char(start_time, 'DD/MM/YYYY') AS day"),DB::raw("date_part('hour', start_time) AS hour"),'t_count_people.site_id','m_site.sitename as site_name','m_device.device_name',DB::raw('SUM(enter) as total_enter'),DB::raw('SUM(exit) as total_exit'))
                    ->join('m_device','m_device.device_id','=','t_count_people.device_id')
                    ->leftJoin('m_site','m_site.site_id','=','t_count_people.site_id')
                    ->where('t_count_people.start_time','>=',$start_date)
                    ->where('t_count_people.start_time','<',$end_date)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'>=',$start_time)
                    ->where(DB::raw('EXTRACT(HOUR FROM t_count_people.start_time)'),'<',$end_param)
                    ->where('m_device.status_record',1)
                    ->whereIn('t_count_people.site_id',$site_id)
                    ->whereIn('t_count_people.device_id',$device_id)
                    ->groupByRaw("to_char(start_time, 'DD/MM/YYYY'),date_part('hour', start_time),t_count_people.site_id,m_site.sitename,m_device.device_name")
                    ->orderByRaw("to_char(start_time, 'DD/MM/YYYY'),date_part('hour', start_time),t_count_people.site_id");
        return $query;
        
    }
}
