<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class MBrand extends Model
{
    use HasFactory;

    protected $table = "m_brand";
    protected $primaryKey = 'id_brand';
    public $timestamps = false;
    protected $fillable = [
    ];
    public static function checkExist($id)
    {
        return self::where('id',$id);
    }

    public static function selectDataTables($id_brand, $start, $length, $search, $sort, $sort_direction){
        $query = "SELECT m_brand.* from m_brand";
        $query .= " where m_brand.deleted = 1";
        if ($id_brand != 0)
        {
            $query .= " and m_brand.id_brand = ".$id_brand;
        }
        //dd($search);
        if ($search != null && $search !='')
        {
            $query .= " AND nama_brand LIKE '%".$search."%'";
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != '')
        {
            $query .= " ORDER BY " . $sort . " " . $sort_direction;
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query .= " LIMIT " . $length;
            $query .= " OFFSET " . $start;
            
        }
        return DB::select($query);
    }

    public static function TotalData_1($id_brand,$search){
        $query = "SELECT count(*) from m_brand";
        $query .= " where m_brand.deleted = 1";
        if ($id_brand != 0)
        {
            $query .= " and m_brand.id_brand = ".$id_brand;
        }
        if ($search != null && $search !='')
        {
            $query .= " AND nama_brand LIKE '%".$search."%'";
        }
        return DB::select($query);
    }

    public static function select_q($id_brand){
        $query = "SELECT m_brand.* from m_brand";
        $query .= " where m_brand.deleted = 1";
        if ($id_brand != 0)
        {
            $query .= " and m_brand.id_brand = ".$id_brand;
        }
        return DB::select($query);
    }

    public static function insert_q($arr_data){
        $id = DB::table('m_brand')->insertGetId($arr_data, 'id_brand');
        return $id;
    }

    public static function update_q($id,$arr_data){
        DB::table('m_brand')->where('id_brand', $id)->update($arr_data);
        return true;
    }

    public static function delete_q($id){
        DB::table('m_brand')->where('id_brand', $id)->update(['deleted'=>0]);
        return true;
    }

    public static function selectIn($list_brand){
        $query = DB::table('m_brand')->where('deleted',1);
        if(count($list_brand) > 0){
            $query->whereIn('id_brand',$list_brand);
        } 
        return $query;
    }

    public static function cekNamaBrand($nama_brand,$id_brand){
       $query = "SELECT count(*) from m_brand";
        $query .= " where deleted=1";
        if ($id_brand != 0)
        {
            $query .= " and id_brand != ".$id_brand;
        }

        if ($nama_brand != null && $nama_brand !='')
        {
            $query .= " and LOWER(nama_brand) LIKE '".$nama_brand."'";
        }
        return DB::select($query);
    }
}
