<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use phpDocumentor\Reflection\DocBlock\Tags\See;
use App\Http\Traits\Helper;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Models\MSite;
use App\Models\MBrand;
use App\Models\MProvinsi;
use App\Models\MKota;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class CUser extends Controller
{    
    public function index()
    {   
        return view('user.index')
            ->with('titlepage','User')
            ->with('title','Camera');
    }

    public function get_data()
    {   
        
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user = User::getUserById($id_user)->first();
        $start = $_GET['start'];
        $search = $_GET['search']['value'];
        $sortColumnName = $_GET['columns'][$_GET["order"][0]['column']]['name'];
        $sortDirection = $_GET['order'][0]['dir'];
        $draw = $_GET['draw'];
        //$length = $_GET['length'];
        //dd($length);
        
        $id_level = $user->id_level;
        $str_list_site = $user->list_user;
        $length = 0;
        if($_GET['length'] == 'all'){
            //$user = MBrand::selectDataTables(0, $start, 0, $search, $sortColumnName, $sortDirection); 
            $length = 0;
        } else {
            $length = $_GET['length'];
            //$user = MBrand::selectDataTables(0, $start, intval($length), $search, $sortColumnName, $sortDirection);
        }
        $query = User::selectDataTables(0,"",$start, $length,$search,$sortColumnName,$sortDirection);
        $data = $query->get();
        $recordsTotal = User::TotalDataV1($search);
        //dd($site);
        foreach($data as $item){
            if ($item->id_level == 1)
            {
                $item->level_text = "Super Admin";
            }
            else if ($item->id_level == 2)
            {
                $item->level_text = "Super Admin";
            }
            else if ($item->id_level == 3)
            {
                $item->level_text = "Admin";
            }
            else
            {
                $item->level_text = "User";
            }
            
        }
        $output = array(
			"draw" => $_GET['draw'],
			"recordsTotal" => $recordsTotal,
			"recordsFiltered" => $query->count(),
			"data" => $data,
		);
		echo json_encode($output, JSON_PRETTY_PRINT);
    }
    public function _decrypt_key($text,$key){
        //$encryptedData = base64_decode($text);
        $decryptedData = openssl_decrypt($text,'aes-128-ecb', $key,0,"");
        return $decryptedData;
    }
    public function create()
    {   
        return view('user.create')
            ->with('titlepage','New User')
            ->with('title','Camera');
    }

    public function create_save(Request $request)
    {   
        
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user_data = User::getUserById($id_user)->first();
        $validator = Validator::make($request->all(),[
            'name' => 'required', 
            'username' => 'required', 
            'password' => 'required', 
            'id_level' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }
        //dd(json_decode($request->id_site));
        $cek_duplicate = User::cekDuplicate(0, $request->username);
        if($cek_duplicate->count() == 0){
            $arr_data = [
                'email' => $request->username,
                'password' => Hash::make($request->password),
                'name' => $request->name,
                'id_level' => $request->id_level,
                'bussiness_id' => $user_data->bussiness_id,
                'deleted' => 1,
                'created_by' => $user_data->id,
            ];
            $id_user = User::insert_q($arr_data);
            
            if($request->id_level == 4){
                $brandArr = json_decode($request->id_brand);
                $provinsiArr = json_decode($request->id_provinsi);
                $siteArr = json_decode($request->id_site);
                $list_brand = [];
                $list_AllSite = [];
                foreach($brandArr as $x => $brand){
                    
                    array_push($list_brand,$brand);
                    $id_brand = $brand;
                    $id_provinsi = $provinsiArr[$x];
                    $selectedSite = $siteArr[$x];
                    $list_site = [];
                    if(count($selectedSite)){
                        foreach($selectedSite as $siteID){
                            array_push($list_site,$siteID);
                            array_push($list_AllSite,$siteID);
                        }
                    } else {
                        //$list_provinsi = [];
                        if ($id_provinsi == 0 || $id_provinsi == null)
                        {
                            $List_provinsi = MSite::selectByBrand($id_brand);
                        } else {
                            $List_provinsi = MSite::selectByBrandProvince($id_brand,$id_provinsi);
                        }
                        foreach($List_provinsi as $data){
                            array_push($list_site,$data->site_id);
                            array_push($list_AllSite,$data->site_id);
                        }
                    }
                    $lst_site = implode(",",$list_site);
                    $dtMap = [
                        'id_user' => $id_user,
                        'id_brand' => $id_brand,
                        'list_site' => $lst_site,
                        'id_provinsi' => $id_provinsi
                    ];
                    User::insertMapUSB($dtMap);
                }
                $uq_list_site = array_unique($list_AllSite);
                $uq_list_brand = array_unique($list_brand);
                $all_site = implode(",",$uq_list_site);
                $all_brand = implode(",",$uq_list_brand);
                $arr_edit = [
                    'list_site' => $all_site,
                    'list_brand' => $all_brand
                ];
                User::update_q($id_user,$arr_edit);
            }
            return response()->json(['message'=>'Success','Code'=>1]);
        } else {
            return response()->json(['message'=>'Duplicate Username','Code'=>2]);
        }
    }

    public function edit($id)
    {   
        config(['database.default' => 'user_connection']);
        $data = User::getUserById($id)->first();
        $brand = MBrand::select_q(0);
        $provinsi = MProvinsi::select_q(0);
        $dataUSB = User::selectUSB($id)->get();
        $count = 1;
        $lenght = 0;
        $arr_site = [];
        foreach($dataUSB as $datas){
            if($datas->id_provinsi != 0){
                $query = MSite::selectByBrandProvince($datas->id_brand,$datas->id_provinsi);
                array_push($arr_site,$query);
            } else {
                $query = MSite::selectByBrand($datas->id_brand);
                array_push($arr_site,$query);
            }
            $lenght++;
            $count++;
        }
        //$kota = MKota::select_q(0,$data[0]->id_provinsi);
        //dd($data[0]->id_provinsi);
        return view('user.edit')
            ->with('titlepage','Update User')
            ->with('data',$data)
            ->with('all_provinsi',$provinsi)
            ->with('all_brand',$brand)
            ->with('dataUSB',$dataUSB)
            ->with('id_user',$id)
            ->with('all_site',$arr_site)
            ->with('lenght',$lenght)
            ->with('startInd',$count)
            ->with('title','Camera');
    }

    public function edit_save(Request $request)
    {   
        $user = Auth::user();
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'name' => 'required', 
            'username' => 'required', 
            'id_level' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }
        //dd(json_decode($request->id_site));
        $id = $request->id_user;
        $cek_duplicate = User::cekDuplicate($id, $request->username);
        if($cek_duplicate->count() == 0){
            $arr_data = [
                'email' => $request->username,
                'name' => $request->name,
                'id_level' => $request->id_level
            ];
            User::update_q($id,$arr_data);
            $id_user = $id;
            User::deleteMapUSB($id);
            if($request->id_level == 4){
                $brandArr = json_decode($request->id_brand);
                $provinsiArr = json_decode($request->id_provinsi);
                $siteArr = json_decode($request->id_site);
                $list_brand = [];
                $list_AllSite = [];
                foreach($brandArr as $x => $brand){
                    
                    array_push($list_brand,$brand);
                    $id_brand = $brand;
                    $id_provinsi = $provinsiArr[$x];
                    $selectedSite = $siteArr[$x];
                    $list_site = [];
                    if(count($selectedSite)){
                        foreach($selectedSite as $siteID){
                            array_push($list_site,$siteID);
                            array_push($list_AllSite,$siteID);
                        }
                    } else {
                        //$list_provinsi = [];
                        if ($id_provinsi == 0 || $id_provinsi == null)
                        {
                            $List_provinsi = MSite::selectByBrand($id_brand);
                        } else {
                            $List_provinsi = MSite::selectByBrandProvince($id_brand,$id_provinsi);
                        }
                        foreach($List_provinsi as $data){
                            array_push($list_site,$data->site_id);
                            array_push($list_AllSite,$data->site_id);
                        }
                    }
                    $lst_site = implode(",",$list_site);
                    $dtMap = [
                        'id_user' => $id_user,
                        'id_brand' => $id_brand,
                        'list_site' => $lst_site,
                        'id_provinsi' => $id_provinsi
                    ];
                    User::insertMapUSB($arr_data);
                }
                $uq_list_site = array_unique($list_AllSite);
                $uq_list_brand = array_unique($list_brand);
                $all_site = implode(",",$uq_list_site);
                $all_brand = implode(",",$uq_list_brand);
                $arr_edit = [
                    'list_site' => $all_site,
                    'list_brand' => $all_brand
                ];
                User::update_q($id_user,$arr_edit);
            }
            return response()->json(['message'=>'Success','Code'=>1]);
        } else {
            return response()->json(['message'=>'Duplicate Username','Code'=>2]);
        }
    }
    public function delete($id)
    {
        config(['database.default' => 'user_connection']);
        User::delete_q($id);      
        return response()->json(['message' => "Hapus Berhasil", 'Code' => "1" ]);
    }

    public function changePassword(){
        $user = Auth::user();
        $data = User::getUserById($user->id)->first();
        return view('user.change_password')
            ->with('titlepage','Change Password')
            ->with('data',$data)
            ->with('title','Camera');
    }

    public function password_save(Request $request){
        $arr_data = [
            'password' => Hash::make($request->password)
        ];
        $id = $request->id;
        User::update_q($id,$arr_data);
        return redirect(url('user/change-password'));
    }

    public function cariProvinsi($id)
    {
        config(['database.default' => 'user_connection']);
        $data = MProvinsi::select_q(0,$id);            
        return response()->json($data);
    }
    
}
