<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use phpDocumentor\Reflection\DocBlock\Tags\See;
use App\Http\Traits\Helper;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Models\MSite;
use App\Models\MBrand;
use App\Models\MProvinsi;
use App\Models\MKota;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class CSite extends Controller
{    
    public function index()
    {   
        return view('site.index')
            ->with('titlepage','Site')
            ->with('title','Camera');
    }

    public function get_data()
    {   
        
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user = User::getUserById($id_user)->first();
        $store_availibility = $_GET['store_availibility'];
        $start = $_GET['start'];
        $search = $_GET['search']['value'];
        $sortColumnName = $_GET['columns'][$_GET["order"][0]['column']]['name'];
        $sortDirection = $_GET['order'][0]['dir'];
        $draw = $_GET['draw'];
        //$length = $_GET['length'];
        //dd($length);
        
        $id_level = $user->id_level;
        $str_list_site = $user->list_user;
        $length = 0;
        if($_GET['length'] == 'all'){
            //$user = MBrand::selectDataTables(0, $start, 0, $search, $sortColumnName, $sortDirection); 
            $length = 0;
        } else {
            $length = $_GET['length'];
            //$user = MBrand::selectDataTables(0, $start, intval($length), $search, $sortColumnName, $sortDirection);
        }

        if ($id_level != 4 || $str_list_site == null)
        {
            //$site_id, $site_code, $start, $length, $search, $sort, $sort_direction,$store_availibility
            $site = MSite::selectDataTables_1(0,"",$start, $length,$search,$sortColumnName,$sortDirection,$store_availibility);
            $recordsTotal = MSite::TotalData_1(0, "", $search, $store_availibility)[0]->count;
            $recordsFiltered = MSite::TotalData_1(0, "", $search, $store_availibility)[0]->count;
        } else {
            //$site_ids = [];
            $site_ids = explode(',',$str_list_site);
            $site = MSite::selectDataTables_2($site_ids, $start, $length, $search, $sortColumnName, $sortDirection, $store_availibility)->get();
            $recordsTotal = MSite::TotalData_2($site_ids, $search, $store_availibility);
            $recordsFiltered = MSite::TotalData_2($site_ids, $search, $store_availibility);
        }
        //dd($site);
        foreach($site as $item){
            if ($item->store_availibility == 1)
            {
                $item->store_availibility_txt = "Operation";
            }
            else if ($item->store_availibility == 2)
            {
                $item->store_availibility_txt = "Renovation";
            }
            else
            {
                $item->store_availibility_txt = "Closed";
            }
            $is_dev = config('constants.is_dev');
            if($item->key_outlet != null && $item->key_outlet != ''){
                if($is_dev){
                    $key = config('constants.api_key_dev');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($item->key_outlet);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    $last10Characters = substr($check_key, -10);
                    //dd($check_key);
                    if($ket_rm_salt == $item->site_code){
                        if($last10Characters == "develop123"){
                            $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                            if($cek_duplicate[0]->count == 0){
                                $item->status_msg = "<i class='fa fa-check text-success' aria-hidden='true'></i> <span class='text-success'>Valid Key</span>";
                                $item->status = 1;
                            } else {
                                $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                                $item->status = 2;
                            }
                        } else {
                            $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                        $item->status = 2;
                    }
                } else {
                    $key = config('constants.api_key_prod');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($check_key);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    if($ket_rm_salt == $item->site_code){
                        $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                        if($cek_duplicate[0]->count == 0){
                            $item->status_msg = "<i class='fa fa-check text-success' aria-hidden='true'></i> <span class='text-success'>Valid Key</span>";
                            $item->status = 1;
                        } else {
                            $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                        $item->status = 2;
                    }
                }
            } else {
                $item->status_msg = "<i class='fa fa-times text-danger' aria-hidden='true'></i> <span class='text-danger'>Invalid Key</span>";
                $item->status = 2;
            }
            
        }
        $output = array(
			"draw" => $_GET['draw'],
			"recordsTotal" => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data" => $site,
		);
		echo json_encode($output, JSON_PRETTY_PRINT);
    }
    public function _decrypt_key($text,$key){
        //$encryptedData = base64_decode($text);
        $decryptedData = openssl_decrypt($text,'aes-128-ecb', $key,0,"");
        return $decryptedData;
    }
    public function create()
    {   
        config(['database.default' => 'user_connection']);
        $brand = MBrand::select_q(0);
        $provinsi = MProvinsi::select_q(0);
        return view('site.create')
            ->with('titlepage','New Site')
            ->with('brand',$brand)
            ->with('provinsi',$provinsi)
            ->with('title','Camera');
    }

    public function create_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'sitename' => 'required', 
            'site_code' => 'required', 
            'divison_id' => 'required', 
            'id_provinsi' => 'required', 
            'id_brand' => 'required', 
            'id_kota' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $user = Auth::user();
        $data = ['sitename' =>$request->sitename,
                    'site_code' =>$request->site_code,
                    'divison_id' =>$request->divison_id,
                    'key_outlet' =>$request->key_outlet,
                    'id_provinsi' =>$request->id_provinsi,
                    'id_kota' =>$request->id_kota,
                    'location_id' =>$request->location_id,
                    ];
        $id_site = MSite::insert_q($data);
        $dataSB = ['id_brand'=>$request->id_brand,'id_site'=>$id_site];
        MSite::insertMapSB($dataSB);
        return response()->json(['message'=>'Success','Code'=>1]);
    }

    public function edit($id)
    {   
        config(['database.default' => 'user_connection']);
        $data = MSite::select_q($id,'');
        $brand = MBrand::select_q(0);
        $provinsi = MProvinsi::select_q(0);
        $kota = MKota::select_q(0,$data[0]->id_provinsi);
        //dd($data[0]->id_provinsi);
        return view('site.edit')
            ->with('titlepage','Update Site')
            ->with('data',$data[0])
            ->with('brand',$brand)
            ->with('provinsi',$provinsi)
            ->with('kota',$kota)
            ->with('title','Camera');
    }
    public function detail($id)
    {   
        config(['database.default' => 'user_connection']);
        $data = MSite::select_q($id,'');
        $brand = MBrand::select_q(0);
        $provinsi = MProvinsi::select_q(0);
        $kota = MKota::select_q(0,$data[0]->id_provinsi);
        //dd($data[0]->id_provinsi);
        return view('site.detail')
            ->with('titlepage','Detail Site')
            ->with('data',$data[0])
            ->with('brand',$brand)
            ->with('provinsi',$provinsi)
            ->with('kota',$kota)
            ->with('title','Camera');
    }

    public function edit_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'sitename' => 'required', 
            'site_code' => 'required', 
            'divison_id' => 'required', 
            'id_provinsi' => 'required', 
            'id_brand' => 'required', 
            'id_kota' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $id = $request->site_id;
        $user = Auth::user();
        $data = ['sitename' =>$request->sitename,
                    'site_code' =>$request->site_code,
                    'divison_id' =>$request->divison_id,
                    'key_outlet' =>$request->key_outlet,
                    'id_provinsi' =>$request->id_provinsi,
                    'id_kota' =>$request->id_kota,
                    'store_availibility' =>$request->store_availibility,
                    ];
        MSite::update_q($id,$data);
        $dataSB = ['id_brand'=>$request->id_brand,'id_site'=>$id];
        $totalDataSB = MSite::TotalDataMapSB($id); 
        if($totalDataSB > 0){
            MSite::updateMapSB($dataSB);
        } else {
            MSite::insertMapSB($dataSB);
        }
        return response()->json(['message'=>'Success','Code'=>1]);
        
    }
    public function delete($id)
    {
        config(['database.default' => 'user_connection']);
        MSite::delete_q($id);
        MSite::DeleteMapSB($id);            
        return response()->json(['message' => "Hapus Berhasil", 'Code' => "1" ]);
    }

    public function CariKotaAll($id)
    {
        config(['database.default' => 'user_connection']);
        $data = MKota::select_q(0,$id);            
        return response()->json($data);
    }

    public function CariSiteAll($id){
        config(['database.default' => 'user_connection']);
        $data = MSite::selectByBrand($id);            
        return response()->json($data);
    }
    
    public function CariSiteAllV2($id,$id_provinsi){
        config(['database.default' => 'user_connection']);
        $data = MSite::selectByBrandProvince($id,$id_provinsi);            
        return response()->json($data);
    }

    public function cekSiteKey(Request $request){
        config(['database.default' => 'user_connection']);
        $site_code = $request->site_code;
        $key_outlet = $request->site_key;
        $site_id = $request->site_id;
        $site_name = $request->site_name;
        $result = [];
        $result["code"] = true;
        if($site_name != ''){
            $total_data = MSite::cekSitename(strtolower($site_name),$site_id);
            //dd($total_data);
            if($total_data[0]->count == 0){
                $result["cek_name"] = true;
            } else {
                $result["cek_name"] = false;
            }
        } else {
            $result["cek_name"] = false;
        }

        if ($site_code != "")
        {
            $total_data = MSite::cekSiteKey($site_code,$site_id);
            if($total_data[0]->count == 0){
                $result["cek_site"] = true;
            } else {
                $result["cek_site"] = false;
            }
            if ($key_outlet != "")
            {
                $is_dev = config('constants.is_dev');
                if($is_dev){
                    $key = config('constants.api_key_dev');
                    $check_key = $this->_decrypt_key($key_outlet,$key);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    $last10Characters = substr($check_key, -10);
                    if($ket_rm_salt == $site_code){
                        if($last10Characters == "develop123"){
                            $result["cek_key"] = true;
                        }else {
                            $result["cek_key"] = false;
                        }
                    }else {
                        $result["cek_key"] = false;
                    }
                } else {
                    $key = config('constants.api_key_prod');
                    $check_key = $this->_decrypt_key($key_outlet,$key);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    if($ket_rm_salt == $site_code){
                        $result["cek_key"] = true;
                    } else {
                        $result["cek_key"] = false;
                    }
                }
            } else {
                $result["cek_key"] = true;
            }
        }
        else
        {
            $result["cek_site"] = false;
            $result["cek_key"] = false;
        }
        return response()->json($result);
    }

    public function ApprovalDevice($id){
        config(['database.default' => 'user_connection']);
        $data = MSite::select_q($id,"");
        if(count($data) > 0){
            $data = $data[0];
            $list_pending = MSite::selectDeviceWSiteIDStatusDevice($id,0);
            $list_approved = MSite::selectDeviceWSiteIDStatusDevice($id,1);
            $is_dev = config('constants.is_dev');
            return view('site.approvalDevice')
            ->with('titlepage','Approval Device')
            ->with('list_pending',$list_pending)
            ->with('list_approved',$list_approved)
            ->with('id',$id)
            ->with('is_dev',$is_dev)
            ->with('sitename',$data->sitename)
            ->with('title','Camera'); 
        } else {
            return redirect(url('site'));
        }
    }

    public function approval(){
        config(['database.default' => 'user_connection']);
        $id = $_GET['id'];
        $list_pending = $_GET['list_pending'];
        $list_approved = $_GET['list_approved'];
        MSite::updateDeviceZero($id);
        if($list_approved != ''){
            $arr_aprroved = explode(",",$list_approved);
            //dd($arr_aprroved);
            foreach($arr_aprroved as $item){
                MSite::updateDeviceSR($item);
            }
        }
        return response()->json(['message'=>'Success','Code'=>1]);
    }
}
