<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Traits\Helper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use App\Models\MSite;
use App\Models\MDevice;
use App\Models\MCountPeople;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Schema;


class CBussiness extends Controller
{    
    public function index(){
        return view('bussiness.index')
            ->with('titlepage','Bussiness')
            ->with('title','Camera');
    }
    
    public function get_data(){
        $start = $_GET['start'];
        $search = $_GET['search']['value'];
        $sortColumnName = $_GET['columns'][$_GET["order"][0]['column']]['name'];
        $sortDirection = $_GET['order'][0]['dir'];
        $draw = $_GET['draw'];
        if($_GET['length'] == 'all'){
            //$user = MBrand::selectDataTables(0, $start, 0, $search, $sortColumnName, $sortDirection); 
            $length = 0;
        } else {
            $length = $_GET['length'];
            //$user = MBrand::selectDataTables(0, $start, intval($length), $search, $sortColumnName, $sortDirection);
        }
        $query = DB::table('m_bussiness');
        if ($search != null && $search !='')
        {
            $query->where(function (Builder $qu) {
                $qu->where('m_bussiness.bussiness_code', 'like', '%'.$search.'%')
                    ->orWhere('m_bussiness.bussiness_name', 'like', '%'.$search.'%');
            });
        }
        $recordsTotal = $query->count();
        if ($sortColumnName != null && $sortColumnName != '' && $sortDirection != null && $sortDirection != '')
        {
            $query->orderBy($sortColumnName,$sortDirection);
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query->offset($start)->limit($length);
        }
        $recordsFiltered = $query->count();
        $data = $query->get();
        $output = array(
			"draw" => $_GET['draw'],
			"recordsTotal" => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data" => $data,
		);
		echo json_encode($output, JSON_PRETTY_PRINT);
    }

    public function create(){
        return view('bussiness.create')
            ->with('titlepage','New Bussiness')
            ->with('title','Camera');
    }

    public function create_save(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'bussiness_name' => 'required', 
            'bussiness_code' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }
        $dbuser = config('constants.bussiness_dbuser');
        $dbpass = config('constants.bussiness_dbpass');
        $data = [
            'bussiness_name'=> $request->bussiness_name,
            'bussiness_code'=> $request->bussiness_code,
            'bussiness_dbuser' => $dbuser,
            'bussiness_dbpass' => $dbpass,
            // 'bussiness_dbhost' => '127.0.0.1',
            // 'bussiness_dbport' => '5432',
            'bussiness_dbhost' => '34.50.104.99',
            'bussiness_dbport' => '5555',
            'bussiness_dbschema' => 'public',
        ];
        $id = DB::table('m_bussiness')->insertGetId($data,'bussiness_id');
        $result = $this->_setup_db($id,$request->bussiness_code);
        DB::table('m_bussiness')->where('bussiness_id',$id)->update(['bussiness_db' => $result['dbname'],'secret_key' => $result['secret_key']]);
       
        return redirect(url('bussiness'));
    }

    public function edit($id)
    {
        $data = DB::table('m_bussiness')->where('bussiness_id',$id)->first();
        return view('bussiness.edit')
            ->with('titlepage','Edite Bussiness')
            ->with('data',$data)
            ->with('title','Camera');
    }

    public function edit_save(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'bussiness_name' => 'required', 
            'bussiness_id' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }
        DB::table('m_bussiness')->where('bussiness_id',$request->bussiness_id)->update(['bussiness_name'=>$request->bussiness_name]);
        return redirect(url('bussiness'));
    }

    public function delete($id)
    {
        return response()->json(['message' => "Hapus Berhasil", 'Code' => "1" ]);
    }

    public function _setup_db($id,$code){
        $secret_key = Crypt::encryptString($code.'##'.$id);
        $dbname = 'pc_'.$code.'_'.$id;
        $dbuser = config('constants.bussiness_dbuser');
        $dbpass = config('constants.bussiness_dbpass');
        $data_db = [
            'bussiness_dbpass' => $dbpass,
            'bussiness_dbuser' => $dbuser,
            'bussiness_db' => $dbname,
            // 'bussiness_dbhost' => '127.0.0.1',
            // 'bussiness_dbport' => '5432',
            'bussiness_dbhost' => '34.50.104.99',
            'bussiness_dbport' => '5555',
            'bussiness_dbschema' => 'public',
        ];
        DB::statement('CREATE DATABASE '.$dbname);
        
        $this->_connect_data($data_db);
        config(['database.default' => 'user_connection_bussiness']);
        DB::statement('CREATE SEQUENCE api_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1');
        DB::statement("CREATE TABLE public.api_logs (id integer DEFAULT nextval('api_logs_id_seq') NOT NULL,site_id integer,device_id integer,ip_address character varying(150),json text,report_date timestamp,created_at timestamp DEFAULT CURRENT_TIMESTAMP,CONSTRAINT api_logs_pkey PRIMARY KEY (id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE flying_tiger_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;");
        DB::statement("CREATE TABLE public.flying_tiger_logs (id integer DEFAULT nextval('flying_tiger_logs_id_seq') NOT NULL,url character varying,json character varying,created_at timestamp DEFAULT CURRENT_TIMESTAMP,result text,site_id integer,CONSTRAINT flying_tiger_logs_pkey PRIMARY KEY (id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE login_logs_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;");
        DB::statement("CREATE TABLE public.login_logs (id integer DEFAULT nextval('login_logs_id_seq') NOT NULL,id_user integer,status integer,created_at timestamp DEFAULT CURRENT_TIMESTAMP,CONSTRAINT login_logs_pkey PRIMARY KEY (id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE m_brand_id_brand_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;");
        DB::statement("CREATE TABLE public.m_brand (id_brand integer DEFAULT nextval('m_brand_id_brand_seq') NOT NULL,nama_brand character varying(150),created_by integer,created_at timestamp DEFAULT CURRENT_TIMESTAMP,edited_by integer,edited_at timestamp,deleted smallint DEFAULT '1',CONSTRAINT m_brand_pkey PRIMARY KEY (id_brand)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE m_device_device_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_device (device_id integer DEFAULT nextval('m_device_device_id_seq') NOT NULL,site_id integer,device_code character varying(150),device_name character varying(150),ip_address character varying,hostname text,serial_number text,object_type integer,external_id character varying(250),last_report timestamp,created_at timestamp DEFAULT CURRENT_TIMESTAMP,status smallint,deleted smallint DEFAULT '1',status_record smallint,camera_type smallint,camera_type_val character varying(100),CONSTRAINT m_device_pkey PRIMARY KEY (device_id)) WITH (oids = false)");

        DB::statement('CREATE SEQUENCE m_kota_id_kota_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1');
        DB::statement("CREATE TABLE public.m_kota (id_kota integer DEFAULT nextval('m_kota_id_kota_seq') NOT NULL,id_provinsi integer,nama_kota character varying(150),created_date timestamp DEFAULT CURRENT_TIMESTAMP,updated_date timestamp,created_by integer,updated_by integer,deleted smallint DEFAULT '1',CONSTRAINT m_kota_pkey PRIMARY KEY (id_kota)) WITH (oids = false)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1101,	11,	'KABUPATEN SIMEULUE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1102,	11,	'KABUPATEN ACEH SINGKIL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1103,	11,	'KABUPATEN ACEH SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1104,	11,	'KABUPATEN ACEH TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1105,	11,	'KABUPATEN ACEH TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1106,	11,	'KABUPATEN ACEH TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1107,	11,	'KABUPATEN ACEH BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1108,	11,	'KABUPATEN ACEH BESAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1109,	11,	'KABUPATEN PIDIE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1110,	11,	'KABUPATEN BIREUEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1111,	11,	'KABUPATEN ACEH UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1112,	11,	'KABUPATEN ACEH BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1113,	11,	'KABUPATEN GAYO LUES',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1114,	11,	'KABUPATEN ACEH TAMIANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1115,	11,	'KABUPATEN NAGAN RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1116,	11,	'KABUPATEN ACEH JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1117,	11,	'KABUPATEN BENER MERIAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1118,	11,	'KABUPATEN PIDIE JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1171,	11,	'KOTA BANDA ACEH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1172,	11,	'KOTA SABANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1173,	11,	'KOTA LANGSA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1174,	11,	'KOTA LHOKSEUMAWE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1175,	11,	'KOTA SUBULUSSALAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1201,	12,	'KABUPATEN NIAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1202,	12,	'KABUPATEN MANDAILING NATAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1203,	12,	'KABUPATEN TAPANULI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1204,	12,	'KABUPATEN TAPANULI TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1205,	12,	'KABUPATEN TAPANULI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1206,	12,	'KABUPATEN TOBA SAMOSIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1207,	12,	'KABUPATEN LABUHAN BATU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1208,	12,	'KABUPATEN ASAHAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1209,	12,	'KABUPATEN SIMALUNGUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1210,	12,	'KABUPATEN DAIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1211,	12,	'KABUPATEN KARO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1212,	12,	'KABUPATEN DELI SERDANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1213,	12,	'KABUPATEN LANGKAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1214,	12,	'KABUPATEN NIAS SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1215,	12,	'KABUPATEN HUMBANG HASUNDUTAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1216,	12,	'KABUPATEN PAKPAK BHARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1217,	12,	'KABUPATEN SAMOSIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1218,	12,	'KABUPATEN SERDANG BEDAGAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1219,	12,	'KABUPATEN BATU BARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1220,	12,	'KABUPATEN PADANG LAWAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1221,	12,	'KABUPATEN PADANG LAWAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1222,	12,	'KABUPATEN LABUHAN BATU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1223,	12,	'KABUPATEN LABUHAN BATU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1224,	12,	'KABUPATEN NIAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1225,	12,	'KABUPATEN NIAS BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1271,	12,	'KOTA SIBOLGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1272,	12,	'KOTA TANJUNG BALAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1273,	12,	'KOTA PEMATANG SIANTAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1274,	12,	'KOTA TEBING TINGGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1275,	12,	'KOTA MEDAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1276,	12,	'KOTA BINJAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1277,	12,	'KOTA PADANGSIDIMPUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1278,	12,	'KOTA GUNUNGSITOLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1301,	13,	'KABUPATEN KEPULAUAN MENTAWAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1302,	13,	'KABUPATEN PESISIR SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1303,	13,	'KABUPATEN SOLOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1304,	13,	'KABUPATEN SIJUNJUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1305,	13,	'KABUPATEN TANAH DATAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1306,	13,	'KABUPATEN PADANG PARIAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1307,	13,	'KABUPATEN AGAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1308,	13,	'KABUPATEN LIMA PULUH KOTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1309,	13,	'KABUPATEN PASAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1310,	13,	'KABUPATEN SOLOK SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1311,	13,	'KABUPATEN DHARMASRAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1312,	13,	'KABUPATEN PASAMAN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1371,	13,	'KOTA PADANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1372,	13,	'KOTA SOLOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1373,	13,	'KOTA SAWAH LUNTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1374,	13,	'KOTA PADANG PANJANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1375,	13,	'KOTA BUKITTINGGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1376,	13,	'KOTA PAYAKUMBUH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1377,	13,	'KOTA PARIAMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1401,	14,	'KABUPATEN KUANTAN SINGINGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1402,	14,	'KABUPATEN INDRAGIRI HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1403,	14,	'KABUPATEN INDRAGIRI HILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1404,	14,	'KABUPATEN PELALAWAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1405,	14,	'KABUPATEN S I A K',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1406,	14,	'KABUPATEN KAMPAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1407,	14,	'KABUPATEN ROKAN HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1408,	14,	'KABUPATEN BENGKALIS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1409,	14,	'KABUPATEN ROKAN HILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1410,	14,	'KABUPATEN KEPULAUAN MERANTI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1471,	14,	'KOTA PEKANBARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1473,	14,	'KOTA D U M A I',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1501,	15,	'KABUPATEN KERINCI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1502,	15,	'KABUPATEN MERANGIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1503,	15,	'KABUPATEN SAROLANGUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1504,	15,	'KABUPATEN BATANG HARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1505,	15,	'KABUPATEN MUARO JAMBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1506,	15,	'KABUPATEN TANJUNG JABUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1507,	15,	'KABUPATEN TANJUNG JABUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1508,	15,	'KABUPATEN TEBO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1509,	15,	'KABUPATEN BUNGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1571,	15,	'KOTA JAMBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1572,	15,	'KOTA SUNGAI PENUH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1601,	16,	'KABUPATEN OGAN KOMERING ULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1602,	16,	'KABUPATEN OGAN KOMERING ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1603,	16,	'KABUPATEN MUARA ENIM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1604,	16,	'KABUPATEN LAHAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1605,	16,	'KABUPATEN MUSI RAWAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1606,	16,	'KABUPATEN MUSI BANYUASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1607,	16,	'KABUPATEN BANYU ASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1608,	16,	'KABUPATEN OGAN KOMERING ULU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1609,	16,	'KABUPATEN OGAN KOMERING ULU TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1610,	16,	'KABUPATEN OGAN ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1611,	16,	'KABUPATEN EMPAT LAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1612,	16,	'KABUPATEN PENUKAL ABAB LEMATANG ILIR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1613,	16,	'KABUPATEN MUSI RAWAS UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1671,	16,	'KOTA PALEMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1672,	16,	'KOTA PRABUMULIH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1673,	16,	'KOTA PAGAR ALAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1674,	16,	'KOTA LUBUKLINGGAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1701,	17,	'KABUPATEN BENGKULU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1702,	17,	'KABUPATEN REJANG LEBONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1703,	17,	'KABUPATEN BENGKULU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1704,	17,	'KABUPATEN KAUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1705,	17,	'KABUPATEN SELUMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1706,	17,	'KABUPATEN MUKOMUKO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1707,	17,	'KABUPATEN LEBONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1708,	17,	'KABUPATEN KEPAHIANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1709,	17,	'KABUPATEN BENGKULU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1771,	17,	'KOTA BENGKULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1801,	18,	'KABUPATEN LAMPUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1802,	18,	'KABUPATEN TANGGAMUS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1803,	18,	'KABUPATEN LAMPUNG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1804,	18,	'KABUPATEN LAMPUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1805,	18,	'KABUPATEN LAMPUNG TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1806,	18,	'KABUPATEN LAMPUNG UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1807,	18,	'KABUPATEN WAY KANAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1808,	18,	'KABUPATEN TULANGBAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1809,	18,	'KABUPATEN PESAWARAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1810,	18,	'KABUPATEN PRINGSEWU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1811,	18,	'KABUPATEN MESUJI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1812,	18,	'KABUPATEN TULANG BAWANG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1813,	18,	'KABUPATEN PESISIR BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1871,	18,	'KOTA BANDAR LAMPUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1872,	18,	'KOTA METRO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1901,	19,	'KABUPATEN BANGKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1902,	19,	'KABUPATEN BELITUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1903,	19,	'KABUPATEN BANGKA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1904,	19,	'KABUPATEN BANGKA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1905,	19,	'KABUPATEN BANGKA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1906,	19,	'KABUPATEN BELITUNG TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (1971,	19,	'KOTA PANGKAL PINANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2101,	21,	'KABUPATEN KARIMUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2102,	21,	'KABUPATEN BINTAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2103,	21,	'KABUPATEN NATUNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2104,	21,	'KABUPATEN LINGGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2105,	21,	'KABUPATEN KEPULAUAN ANAMBAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2171,	21,	'KOTA B A T A M',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (2172,	21,	'KOTA TANJUNG PINANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3101,	31,	'KABUPATEN KEPULAUAN SERIBU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3171,	31,	'KOTA JAKARTA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3172,	31,	'KOTA JAKARTA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3173,	31,	'KOTA JAKARTA PUSAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3174,	31,	'KOTA JAKARTA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3175,	31,	'KOTA JAKARTA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3201,	32,	'KABUPATEN BOGOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3202,	32,	'KABUPATEN SUKABUMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3203,	32,	'KABUPATEN CIANJUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3204,	32,	'KABUPATEN BANDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3205,	32,	'KABUPATEN GARUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3206,	32,	'KABUPATEN TASIKMALAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3207,	32,	'KABUPATEN CIAMIS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3208,	32,	'KABUPATEN KUNINGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3209,	32,	'KABUPATEN CIREBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3210,	32,	'KABUPATEN MAJALENGKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3211,	32,	'KABUPATEN SUMEDANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3212,	32,	'KABUPATEN INDRAMAYU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3213,	32,	'KABUPATEN SUBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3214,	32,	'KABUPATEN PURWAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3215,	32,	'KABUPATEN KARAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3216,	32,	'KABUPATEN BEKASI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3217,	32,	'KABUPATEN BANDUNG BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3218,	32,	'KABUPATEN PANGANDARAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3271,	32,	'KOTA BOGOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3272,	32,	'KOTA SUKABUMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3273,	32,	'KOTA BANDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3274,	32,	'KOTA CIREBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3275,	32,	'KOTA BEKASI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3276,	32,	'KOTA DEPOK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3277,	32,	'KOTA CIMAHI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3278,	32,	'KOTA TASIKMALAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3279,	32,	'KOTA BANJAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3301,	33,	'KABUPATEN CILACAP',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3302,	33,	'KABUPATEN BANYUMAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3303,	33,	'KABUPATEN PURBALINGGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3304,	33,	'KABUPATEN BANJARNEGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3305,	33,	'KABUPATEN KEBUMEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3306,	33,	'KABUPATEN PURWOREJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3307,	33,	'KABUPATEN WONOSOBO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3308,	33,	'KABUPATEN MAGELANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3309,	33,	'KABUPATEN BOYOLALI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3310,	33,	'KABUPATEN KLATEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3311,	33,	'KABUPATEN SUKOHARJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3312,	33,	'KABUPATEN WONOGIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3313,	33,	'KABUPATEN KARANGANYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3314,	33,	'KABUPATEN SRAGEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3315,	33,	'KABUPATEN GROBOGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3316,	33,	'KABUPATEN BLORA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3317,	33,	'KABUPATEN REMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3318,	33,	'KABUPATEN PATI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3319,	33,	'KABUPATEN KUDUS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3320,	33,	'KABUPATEN JEPARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3321,	33,	'KABUPATEN DEMAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3322,	33,	'KABUPATEN SEMARANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3323,	33,	'KABUPATEN TEMANGGUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3324,	33,	'KABUPATEN KENDAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3325,	33,	'KABUPATEN BATANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3326,	33,	'KABUPATEN PEKALONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3327,	33,	'KABUPATEN PEMALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3328,	33,	'KABUPATEN TEGAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3329,	33,	'KABUPATEN BREBES',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3371,	33,	'KOTA MAGELANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3372,	33,	'KOTA SURAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3373,	33,	'KOTA SALATIGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3374,	33,	'KOTA SEMARANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3375,	33,	'KOTA PEKALONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3376,	33,	'KOTA TEGAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3401,	34,	'KABUPATEN KULON PROGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3402,	34,	'KABUPATEN BANTUL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3403,	34,	'KABUPATEN GUNUNG KIDUL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3404,	34,	'KABUPATEN SLEMAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3471,	34,	'KOTA YOGYAKARTA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3501,	35,	'KABUPATEN PACITAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3502,	35,	'KABUPATEN PONOROGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3503,	35,	'KABUPATEN TRENGGALEK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3504,	35,	'KABUPATEN TULUNGAGUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3505,	35,	'KABUPATEN BLITAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3506,	35,	'KABUPATEN KEDIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3507,	35,	'KABUPATEN MALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3508,	35,	'KABUPATEN LUMAJANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3509,	35,	'KABUPATEN JEMBER',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3510,	35,	'KABUPATEN BANYUWANGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3511,	35,	'KABUPATEN BONDOWOSO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3512,	35,	'KABUPATEN SITUBONDO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3513,	35,	'KABUPATEN PROBOLINGGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3514,	35,	'KABUPATEN PASURUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3515,	35,	'KABUPATEN SIDOARJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3516,	35,	'KABUPATEN MOJOKERTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3517,	35,	'KABUPATEN JOMBANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3518,	35,	'KABUPATEN NGANJUK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3519,	35,	'KABUPATEN MADIUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3520,	35,	'KABUPATEN MAGETAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3521,	35,	'KABUPATEN NGAWI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3522,	35,	'KABUPATEN BOJONEGORO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3523,	35,	'KABUPATEN TUBAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3524,	35,	'KABUPATEN LAMONGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3525,	35,	'KABUPATEN GRESIK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3526,	35,	'KABUPATEN BANGKALAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3527,	35,	'KABUPATEN SAMPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3528,	35,	'KABUPATEN PAMEKASAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3529,	35,	'KABUPATEN SUMENEP',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3571,	35,	'KOTA KEDIRI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3572,	35,	'KOTA BLITAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3573,	35,	'KOTA MALANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3574,	35,	'KOTA PROBOLINGGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3575,	35,	'KOTA PASURUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3576,	35,	'KOTA MOJOKERTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3577,	35,	'KOTA MADIUN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3578,	35,	'KOTA SURABAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3579,	35,	'KOTA BATU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3601,	36,	'KABUPATEN PANDEGLANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3602,	36,	'KABUPATEN LEBAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3603,	36,	'KABUPATEN TANGERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3604,	36,	'KABUPATEN SERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3671,	36,	'KOTA TANGERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3672,	36,	'KOTA CILEGON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3673,	36,	'KOTA SERANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (3674,	36,	'KOTA TANGERANG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5101,	51,	'KABUPATEN JEMBRANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5102,	51,	'KABUPATEN TABANAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5103,	51,	'KABUPATEN BADUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5104,	51,	'KABUPATEN GIANYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5105,	51,	'KABUPATEN KLUNGKUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5106,	51,	'KABUPATEN BANGLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5107,	51,	'KABUPATEN KARANG ASEM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5108,	51,	'KABUPATEN BULELENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5171,	51,	'KOTA DENPASAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5201,	52,	'KABUPATEN LOMBOK BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5202,	52,	'KABUPATEN LOMBOK TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5203,	52,	'KABUPATEN LOMBOK TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5204,	52,	'KABUPATEN SUMBAWA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5205,	52,	'KABUPATEN DOMPU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5206,	52,	'KABUPATEN BIMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5207,	52,	'KABUPATEN SUMBAWA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5208,	52,	'KABUPATEN LOMBOK UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5271,	52,	'KOTA MATARAM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5272,	52,	'KOTA BIMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5301,	53,	'KABUPATEN SUMBA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5302,	53,	'KABUPATEN SUMBA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5303,	53,	'KABUPATEN KUPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5304,	53,	'KABUPATEN TIMOR TENGAH SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5305,	53,	'KABUPATEN TIMOR TENGAH UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5306,	53,	'KABUPATEN BELU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5307,	53,	'KABUPATEN ALOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5308,	53,	'KABUPATEN LEMBATA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5309,	53,	'KABUPATEN FLORES TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5310,	53,	'KABUPATEN SIKKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5311,	53,	'KABUPATEN ENDE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5312,	53,	'KABUPATEN NGADA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5313,	53,	'KABUPATEN MANGGARAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5314,	53,	'KABUPATEN ROTE NDAO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5315,	53,	'KABUPATEN MANGGARAI BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5316,	53,	'KABUPATEN SUMBA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5317,	53,	'KABUPATEN SUMBA BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5318,	53,	'KABUPATEN NAGEKEO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5319,	53,	'KABUPATEN MANGGARAI TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5320,	53,	'KABUPATEN SABU RAIJUA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5321,	53,	'KABUPATEN MALAKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (5371,	53,	'KOTA KUPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6101,	61,	'KABUPATEN SAMBAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6102,	61,	'KABUPATEN BENGKAYANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6103,	61,	'KABUPATEN LANDAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6104,	61,	'KABUPATEN MEMPAWAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6105,	61,	'KABUPATEN SANGGAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6106,	61,	'KABUPATEN KETAPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6107,	61,	'KABUPATEN SINTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6108,	61,	'KABUPATEN KAPUAS HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6109,	61,	'KABUPATEN SEKADAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6110,	61,	'KABUPATEN MELAWI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6111,	61,	'KABUPATEN KAYONG UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6112,	61,	'KABUPATEN KUBU RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6171,	61,	'KOTA PONTIANAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6172,	61,	'KOTA SINGKAWANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6201,	62,	'KABUPATEN KOTAWARINGIN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6202,	62,	'KABUPATEN KOTAWARINGIN TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6203,	62,	'KABUPATEN KAPUAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6204,	62,	'KABUPATEN BARITO SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6205,	62,	'KABUPATEN BARITO UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6206,	62,	'KABUPATEN SUKAMARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6207,	62,	'KABUPATEN LAMANDAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6208,	62,	'KABUPATEN SERUYAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6209,	62,	'KABUPATEN KATINGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6210,	62,	'KABUPATEN PULANG PISAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6211,	62,	'KABUPATEN GUNUNG MAS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6212,	62,	'KABUPATEN BARITO TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6213,	62,	'KABUPATEN MURUNG RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6271,	62,	'KOTA PALANGKA RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6301,	63,	'KABUPATEN TANAH LAUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6302,	63,	'KABUPATEN KOTA BARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6303,	63,	'KABUPATEN BANJAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6304,	63,	'KABUPATEN BARITO KUALA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6305,	63,	'KABUPATEN TAPIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6306,	63,	'KABUPATEN HULU SUNGAI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6307,	63,	'KABUPATEN HULU SUNGAI TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6308,	63,	'KABUPATEN HULU SUNGAI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6309,	63,	'KABUPATEN TABALONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6310,	63,	'KABUPATEN TANAH BUMBU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6311,	63,	'KABUPATEN BALANGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6371,	63,	'KOTA BANJARMASIN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6372,	63,	'KOTA BANJAR BARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6401,	64,	'KABUPATEN PASER',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6402,	64,	'KABUPATEN KUTAI BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6403,	64,	'KABUPATEN KUTAI KARTANEGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6404,	64,	'KABUPATEN KUTAI TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6405,	64,	'KABUPATEN BERAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6409,	64,	'KABUPATEN PENAJAM PASER UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6411,	64,	'KABUPATEN MAHAKAM HULU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6471,	64,	'KOTA BALIKPAPAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6472,	64,	'KOTA SAMARINDA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6474,	64,	'KOTA BONTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6501,	65,	'KABUPATEN MALINAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6502,	65,	'KABUPATEN BULUNGAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6503,	65,	'KABUPATEN TANA TIDUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6504,	65,	'KABUPATEN NUNUKAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (6571,	65,	'KOTA TARAKAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7101,	71,	'KABUPATEN BOLAANG MONGONDOW',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7102,	71,	'KABUPATEN MINAHASA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7103,	71,	'KABUPATEN KEPULAUAN SANGIHE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7104,	71,	'KABUPATEN KEPULAUAN TALAUD',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7105,	71,	'KABUPATEN MINAHASA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7106,	71,	'KABUPATEN MINAHASA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7107,	71,	'KABUPATEN BOLAANG MONGONDOW UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7108,	71,	'KABUPATEN SIAU TAGULANDANG BIARO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7109,	71,	'KABUPATEN MINAHASA TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7110,	71,	'KABUPATEN BOLAANG MONGONDOW SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7111,	71,	'KABUPATEN BOLAANG MONGONDOW TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7171,	71,	'KOTA MANADO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7172,	71,	'KOTA BITUNG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7173,	71,	'KOTA TOMOHON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7174,	71,	'KOTA KOTAMOBAGU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7201,	72,	'KABUPATEN BANGGAI KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7202,	72,	'KABUPATEN BANGGAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7203,	72,	'KABUPATEN MOROWALI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7204,	72,	'KABUPATEN POSO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7205,	72,	'KABUPATEN DONGGALA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7206,	72,	'KABUPATEN TOLI-TOLI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7207,	72,	'KABUPATEN BUOL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7208,	72,	'KABUPATEN PARIGI MOUTONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7209,	72,	'KABUPATEN TOJO UNA-UNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7210,	72,	'KABUPATEN SIGI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7211,	72,	'KABUPATEN BANGGAI LAUT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7212,	72,	'KABUPATEN MOROWALI UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7271,	72,	'KOTA PALU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7301,	73,	'KABUPATEN KEPULAUAN SELAYAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7302,	73,	'KABUPATEN BULUKUMBA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7303,	73,	'KABUPATEN BANTAENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7304,	73,	'KABUPATEN JENEPONTO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7305,	73,	'KABUPATEN TAKALAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7306,	73,	'KABUPATEN GOWA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7307,	73,	'KABUPATEN SINJAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7308,	73,	'KABUPATEN MAROS',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7309,	73,	'KABUPATEN PANGKAJENE DAN KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7310,	73,	'KABUPATEN BARRU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7311,	73,	'KABUPATEN BONE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7312,	73,	'KABUPATEN SOPPENG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7313,	73,	'KABUPATEN WAJO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7314,	73,	'KABUPATEN SIDENRENG RAPPANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7315,	73,	'KABUPATEN PINRANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7316,	73,	'KABUPATEN ENREKANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7317,	73,	'KABUPATEN LUWU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7318,	73,	'KABUPATEN TANA TORAJA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7322,	73,	'KABUPATEN LUWU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7325,	73,	'KABUPATEN LUWU TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7326,	73,	'KABUPATEN TORAJA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7371,	73,	'KOTA MAKASSAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7372,	73,	'KOTA PAREPARE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7373,	73,	'KOTA PALOPO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7401,	74,	'KABUPATEN BUTON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7402,	74,	'KABUPATEN MUNA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7403,	74,	'KABUPATEN KONAWE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7404,	74,	'KABUPATEN KOLAKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7405,	74,	'KABUPATEN KONAWE SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7406,	74,	'KABUPATEN BOMBANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7407,	74,	'KABUPATEN WAKATOBI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7408,	74,	'KABUPATEN KOLAKA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7409,	74,	'KABUPATEN BUTON UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7410,	74,	'KABUPATEN KONAWE UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7411,	74,	'KABUPATEN KOLAKA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7412,	74,	'KABUPATEN KONAWE KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7413,	74,	'KABUPATEN MUNA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7414,	74,	'KABUPATEN BUTON TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7415,	74,	'KABUPATEN BUTON SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7471,	74,	'KOTA KENDARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7472,	74,	'KOTA BAUBAU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7501,	75,	'KABUPATEN BOALEMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7502,	75,	'KABUPATEN GORONTALO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7503,	75,	'KABUPATEN POHUWATO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7504,	75,	'KABUPATEN BONE BOLANGO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7505,	75,	'KABUPATEN GORONTALO UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7571,	75,	'KOTA GORONTALO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7601,	76,	'KABUPATEN MAJENE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7602,	76,	'KABUPATEN POLEWALI MANDAR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7603,	76,	'KABUPATEN MAMASA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7604,	76,	'KABUPATEN MAMUJU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7605,	76,	'KABUPATEN MAMUJU UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (7606,	76,	'KABUPATEN MAMUJU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8101,	81,	'KABUPATEN MALUKU TENGGARA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8102,	81,	'KABUPATEN MALUKU TENGGARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8103,	81,	'KABUPATEN MALUKU TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8104,	81,	'KABUPATEN BURU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8105,	81,	'KABUPATEN KEPULAUAN ARU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8106,	81,	'KABUPATEN SERAM BAGIAN BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8107,	81,	'KABUPATEN SERAM BAGIAN TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8108,	81,	'KABUPATEN MALUKU BARAT DAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8109,	81,	'KABUPATEN BURU SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8171,	81,	'KOTA AMBON',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8172,	81,	'KOTA TUAL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8201,	82,	'KABUPATEN HALMAHERA BARAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8202,	82,	'KABUPATEN HALMAHERA TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8203,	82,	'KABUPATEN KEPULAUAN SULA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8204,	82,	'KABUPATEN HALMAHERA SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8205,	82,	'KABUPATEN HALMAHERA UTARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8206,	82,	'KABUPATEN HALMAHERA TIMUR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8207,	82,	'KABUPATEN PULAU MOROTAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8208,	82,	'KABUPATEN PULAU TALIABU',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8271,	82,	'KOTA TERNATE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (8272,	82,	'KOTA TIDORE KEPULAUAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9101,	91,	'KABUPATEN FAKFAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9102,	91,	'KABUPATEN KAIMANA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9103,	91,	'KABUPATEN TELUK WONDAMA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9104,	91,	'KABUPATEN TELUK BINTUNI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9105,	91,	'KABUPATEN MANOKWARI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9106,	91,	'KABUPATEN SORONG SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9107,	91,	'KABUPATEN SORONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9108,	91,	'KABUPATEN RAJA AMPAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9109,	91,	'KABUPATEN TAMBRAUW',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9110,	91,	'KABUPATEN MAYBRAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9111,	91,	'KABUPATEN MANOKWARI SELATAN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9112,	91,	'KABUPATEN PEGUNUNGAN ARFAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9171,	91,	'KOTA SORONG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9401,	94,	'KABUPATEN MERAUKE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9402,	94,	'KABUPATEN JAYAWIJAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9403,	94,	'KABUPATEN JAYAPURA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9404,	94,	'KABUPATEN NABIRE',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9408,	94,	'KABUPATEN KEPULAUAN YAPEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9409,	94,	'KABUPATEN BIAK NUMFOR',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9410,	94,	'KABUPATEN PANIAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9411,	94,	'KABUPATEN PUNCAK JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9412,	94,	'KABUPATEN MIMIKA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9413,	94,	'KABUPATEN BOVEN DIGOEL',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9414,	94,	'KABUPATEN MAPPI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9415,	94,	'KABUPATEN ASMAT',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9416,	94,	'KABUPATEN YAHUKIMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9417,	94,	'KABUPATEN PEGUNUNGAN BINTANG',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9418,	94,	'KABUPATEN TOLIKARA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9419,	94,	'KABUPATEN SARMI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9420,	94,	'KABUPATEN KEEROM',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9426,	94,	'KABUPATEN WAROPEN',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9427,	94,	'KABUPATEN SUPIORI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9428,	94,	'KABUPATEN MAMBERAMO RAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9429,	94,	'KABUPATEN NDUGA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9430,	94,	'KABUPATEN LANNY JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9431,	94,	'KABUPATEN MAMBERAMO TENGAH',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9432,	94,	'KABUPATEN YALIMO',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9433,	94,	'KABUPATEN PUNCAK',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9434,	94,	'KABUPATEN DOGIYAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9435,	94,	'KABUPATEN INTAN JAYA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9436,	94,	'KABUPATEN DEIYAI',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9471,	94,	'KOTA JAYAPURA',	'2016-08-05 06:30:02',	'2016-08-05 13:30:02',	1,	1,	1)");
        DB::statement("INSERT INTO m_kota (id_kota, id_provinsi, nama_kota, created_date, updated_date, created_by, updated_by, deleted) VALUES (9472,	81,	'KABUPATEN MALUKU BARAT DAYA',	'2017-06-15 16:12:17',	'2017-06-15 23:21:29',	1,	1,	1)");

        DB::statement("CREATE SEQUENCE m_outlet_id_outlet_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_outlet (id_outlet integer DEFAULT nextval('m_outlet_id_outlet_seq') NOT NULL,nama_outlet character varying(150),kode_outlet character varying(150),key_outlet text,created_at timestamp DEFAULT CURRENT_TIMESTAMP,created_by integer,CONSTRAINT m_outlet_pkey PRIMARY KEY (id_outlet)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE m_provinsi_id_provinsi_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_provinsi (id_provinsi integer DEFAULT nextval('m_provinsi_id_provinsi_seq') NOT NULL,nama_provinsi character varying(150),created_date timestamp DEFAULT CURRENT_TIMESTAMP,updated_date timestamp,created_by integer,updated_by integer,deleted smallint DEFAULT '1',CONSTRAINT m_provinsi_pkey PRIMARY KEY (id_provinsi)) WITH (oids = false)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (11,	'ACEH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (12,	'SUMATERA UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (13,	'SUMATERA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (14,	'RIAU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (15,	'JAMBI',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (16,	'SUMATERA SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (17,	'BENGKULU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (18,	'LAMPUNG',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (19,	'KEPULAUAN BANGKA BELITUNG',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (21,	'KEPULAUAN RIAU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (31,	'DKI JAKARTA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (32,	'JAWA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (33,	'JAWA TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (34,	'DI YOGYAKARTA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (35,	'JAWA TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (36,	'BANTEN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (51,	'BALI',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (52,	'NUSA TENGGARA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (53,	'NUSA TENGGARA TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (61,	'KALIMANTAN BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (62,	'KALIMANTAN TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (63,	'KALIMANTAN SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (64,	'KALIMANTAN TIMUR',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (65,	'KALIMANTAN UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (71,	'SULAWESI UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (72,	'SULAWESI TENGAH',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (73,	'SULAWESI SELATAN',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (74,	'SULAWESI TENGGARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (75,	'GORONTALO',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (76,	'SULAWESI BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (81,	'MALUKU',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (82,	'MALUKU UTARA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (91,	'PAPUA BARAT',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");
        DB::statement("INSERT INTO m_provinsi (id_provinsi, nama_provinsi, created_date, updated_date, created_by, updated_by, deleted) VALUES (94,	'PAPUA',	'2016-08-05 06:21:31',	'2016-08-05 13:21:31',	1,	1,	1)");

        DB::statement("CREATE SEQUENCE m_setting_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_setting (id integer DEFAULT nextval('m_setting_id_seq') NOT NULL,name character varying(200),code character varying(200),value character varying(255),CONSTRAINT m_setting_pkey PRIMARY KEY (id)) WITH (oids = false)");
        DB::statement("INSERT INTO m_setting (id, name, code, value) VALUES(1,	'Last Id Migration',	'last_id_migration',	'1')");

        DB::statement("CREATE SEQUENCE m_site_site_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_site (site_id integer DEFAULT nextval('m_site_site_id_seq') NOT NULL,sitename character varying(255),site_code character varying(150),divison_id character varying(50),created_at timestamp DEFAULT CURRENT_TIMESTAMP,key_outlet character varying,deleted smallint DEFAULT '1',id_provinsi integer,id_kota integer,from_migration integer,location_id character varying(150),store_availibility integer DEFAULT '1',CONSTRAINT m_site_pkey PRIMARY KEY (site_id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE m_user_id_user_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.m_user (id_user integer DEFAULT nextval('m_user_id_user_seq') NOT NULL,username character varying,password text,id_level smallint,created_at timestamp DEFAULT CURRENT_TIMESTAMP,created_by integer,deleted smallint DEFAULT '1',list_site text,list_brand text,name character varying(200),CONSTRAINT m_user_pkey PRIMARY KEY (id_user)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE map_site_brand_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.map_site_brand (id integer DEFAULT nextval('map_site_brand_id_seq') NOT NULL,id_brand integer NOT NULL,id_site integer NOT NULL,CONSTRAINT map_site_brand_pkey PRIMARY KEY (id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE map_user_site_brand_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.map_user_site_brand (id integer DEFAULT nextval('map_user_site_brand_id_seq') NOT NULL,id_user integer,id_brand integer,list_site text,id_provinsi integer,CONSTRAINT map_user_site_brand_pkey PRIMARY KEY (id)) WITH (oids = false)");

        DB::statement("CREATE SEQUENCE t_count_people_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.t_count_people (id integer DEFAULT nextval('t_count_people_id_seq') NOT NULL,site_id integer,site_name character varying(255),device_id integer,device_name character varying(250),start_time timestamp,end_time timestamp,enter integer,exit integer,status smallint,created_at timestamp DEFAULT CURRENT_TIMESTAMP,from_migration integer,CONSTRAINT t_count_people_pkey PRIMARY KEY (id)) WITH (oids = false);");

        DB::statement("CREATE SEQUENCE users_id_seq INCREMENT 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1");
        DB::statement("CREATE TABLE public.users (email character varying,password text,id_level smallint,created_at timestamp,created_by integer,deleted smallint,list_site text,list_brand text,name character varying(200),id integer DEFAULT nextval('users_id_seq') NOT NULL,bussiness_id smallint,CONSTRAINT users_pkey PRIMARY KEY (id)) WITH (oids = false)");
        DB::statement("INSERT INTO users (email, password, id_level, created_at, created_by, deleted, list_site, list_brand, name, id, bussiness_id) VALUES ('admin',	'$2y$10\$aluTgec/4vn42tkmNRdrLOIqaAETaFK6QHKjIs5yKAmid0Lf.3FIC',	2,	'2024-06-05 11:05:22.287275',	1,	1,	NULL,	NULL,	'admin',	3,	".$id.")");

        config(['database.default' => 'pgsql']);
        $res = ['dbname'=>$dbname,'secret_key'=>$secret_key];

        return $res;
    }

    public function test_data_2(){
        $path = public_path().'\upload\master_data.sql';
        //DB::statement('CREATE DATABASE test_db');
        $dbuser = config('constants.bussiness_dbuser');
        $dbpass = config('constants.bussiness_dbpass');
        $expolde_pass = explode('"',Crypt::decryptString($dbpass));
        $command = sprintf(
            'set PGPASSWORD="%s" psql -h %s -U %s -d %s -f %s',
            $expolde_pass[0],
            // '127.0.0.1',
            '34.50.104.99',
            $dbuser,
            'test_db',
            $path
        );
        $output = null;
        $resultCode = null;
        dd($command);
        exec($command, $output, $resultCode);
        if ($resultCode === 0) {
            dd($output);
            //$this->info("Database backup successfully transferred to the target database.");
        } else {
            dd($command);
            //$this->error("Failed to transfer the database backup. Error code: $resultCode");
        }
    }
    public function update_v1(){
        //if exist
    }
    public function test_data(){
        $dbuser = config('constants.bussiness_dbuser');
        $dbpass = config('constants.bussiness_dbpass');
        $data_db = [
            'bussiness_dbpass' => $dbpass,
            'bussiness_dbuser' => $dbuser,
            'bussiness_db' => 'test_db',
            'bussiness_dbhost' => '127.0.0.1',
            'bussiness_dbport' => '5432',
            'bussiness_dbschema' => 'public',
        ];
        //DB::statement('CREATE DATABASE test_db');
        $this->_connect_data($data_db);
        config(['database.default' => 'default_pgsql']);
        $tables = Schema::getAllTables();
        $arr_data = [];
       
        
        foreach ($tables as $table) {
            //$table = $table->tablename;
            config(['database.default' => 'default_pgsql']);
            $sourceData = DB::table($table->tablename)->get();
            //array_push($arr_data,$sourceData);
            config(['database.default' => 'user_connection_bussiness']);
            if(count($sourceData) > 0){
                foreach($sourceData as $data){
                    $arr_dt = (array) $data;
                    DB::connection('user_connection_bussiness')->table($table->tablename)->insert($arr_dt)->toSql(); // kenek
                }
            }
        }
    }

    public function _connect_data($data){
        $expolde_pass = explode('"',Crypt::decryptString($data['bussiness_dbpass']));
        Config::set('database.connections.user_connection_bussiness', [
            'driver' => 'pgsql',
            'host' => $data['bussiness_dbhost'],
            'port' => $data['bussiness_dbport'],
            'database' => $data['bussiness_db'],
            'username' => $data['bussiness_dbuser'],
            'password' => $expolde_pass[0],
            'charset' => 'utf8',
            'prefix' => '',
            'schema' => $data['bussiness_dbschema'],
            'sslmode' => 'prefer',
        ]);
        //print_r($expolde_pass[1]);exit();
        DB::purge('user_connection_bussiness');
        DB::reconnect('user_connection_bussiness');
    }
}
