<?php $__env->startPush('css-app'); ?>
<style>
    .btn-tranparent {
        font-size: 0.82rem;
        color: #2E526B !important;
        font-weight: 400;
        line-height: 1.5;
        box-shadow: 0 0 0 0 transparent !important;
        vertical-align: unset;
        padding: 0;
        text-align: left;
        border: 0px solid transparent;
        border-radius: 0px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="card border-0  my-2">
    <div class="card-body">
        <a href="<?php echo e(url('device/create')); ?>" class='btn btn-primary mb-3'><i class='fas fa-plus-circle'></i>Tambah</a>
        <table class="table table-striped" id="table">
            <thead>
            <th>Device Name</th>
            <th>Device Code</th>
            <th>Site Name</th>
            <th>IP Address</th>
            <th>Last Update</th>
            <th>Status</th>
            <th>Action</th>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

<script>
    function load_data(){
        table = $('#table').AppTable({
            url: '<?php echo e(url("device/get-data")); ?>',
            column: [
                { "data": "device_name", "name": "device_name" },
                { "data": "device_code", "name": "device_code" },
                { "data": "site_name", "name": "site_name" },
                { "data": "ip_address", "name": "ip_address" },
                { "data": "last_update", "name": "last_report" },
                { "data": "status_msg", "name": "status" },
                {
                    "data": "device_id",
                    sortable: false,
                    "render": function (data, type, row) {
                        var id = data;
                        return "<div class='dropdown'>\
                                <button class='btn btn-tranparent dropdown-toggle' type='button' id='dropdownMenuButton' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false' >\
                                    <i class='fas fa-ellipsis-h'></i>\
                                </button>\
                                <div class='dropdown-menu' aria-labelledby='dropdownMenuButton'>\
                                    <a class='dropdown-item' href='<?php echo e(url("device/detail")); ?>/" + id +"'>Detail</a>\
                                    <a class='dropdown-item' href='<?php echo e(url("device/edit")); ?>/" + id +"'>Edit</a>\
                                    <a class='dropdown-item deleteRow' href='<?php echo e(url("device/delete")); ?>/" + id + "'>Delete</a>\
                                </div>\
                            </div>";
                    }
                },
            ],

        })
    }
    load_data();
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/peoplecounting/resources/views/device/index.blade.php ENDPATH**/ ?>