@push('css-app')
<style>
    .select2-container {
        width: 100% !important;
    }

    .select2-container--default.select2-container--focus .select2-selection--multiple {
        border: 1px solid #d1d3e2;
        min-height: calc(1.5em + 0.75rem + 5px);
        border-radius: 0.35rem;
    }

    .select2-container--default .select2-selection--multiple {
        border: 1px solid #d1d3e2;
        min-height: calc(1.5em + 0.75rem + 5px);
        border-radius: 0.35rem;
    }

    .select2-selection {
        overflow-y: auto;
        white-space: nowrap;
        -ms-overflow-style: none; /* IE and Edge */
        scrollbar-width: none; /* Firefox */
    }

        .select2-selection::-webkit-scrollbar {
            display: none;
        }

    ul.select2-selection__rendered {
        white-space: nowrap;
    }
    .btn-remove {
        margin-top: 2.6rem;
    }
</style>
@endpush
@extends('template')
@section('content')
<?php use App\Http\Traits\Helper; ?>
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card border-0  my-2">
    <div class="card-body">
        <form id="formUser" method="post">
            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" id="name" class="form-control" value="{{$data->name}}" />
                <input type="hidden" name="id" id="id" value="{{$data->id}}">
            </div>
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" id="username" class="form-control" value="{{$data->email}}" />
            </div>
            <div class="form-group">
                <label>Level</label>
                <select name="id_level" id="id_level" class="form-control">

                    <option value="3" 
                        @if($data->id_level == 3) 
                        "selected" 
                        @endif
                    >Admin</option>
                    <option value="4" @if($data->id_level == 4) "selected" @endif>User</option>
                </select>
            </div>
            <div style="margin-bottom:20px;">
                <div id="list_brand">
                    <?php
                        $ind_lb = 0;
                        $myArray = [];
                        /*if(is_array($data->list_brand)){
                            $myArray = $list_brand;
                        }*/
                        
                        $selected = "selected";

                    ?>
                    @if($lenght > 0)
                        @foreach($dataUSB as $item)
                            <?php
                            $list_site = explode(',',$item->list_site);
                            $myArraySite = is_array($list_site) ? $list_site : array();
                            ?>
                            <div class="row" id="row_brand_site_{{$ind_lb}}">
                                
                                <div class="col-11 row">
                                    <div class="form-group col-md-4">
                                        <label>Brand</label>
                                        <select name="id_brand[]" id="id_brand_{{$ind_lb}}" data-ids="{{$ind_lb}}" onchange="changeBrand({{$ind_lb}})" class="form-control id_brand">
                                            @foreach ($all_brand as $itm_brand)
                                            
                                                <option value="{{$itm_brand->id_brand}}" @if($item->id_brand == $itm_brand->id_brand) "selected" @endif>{{$itm_brand->nama_brand}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Province</label>
                                        <select name="id_provinsi[]" id="id_provinsi_{{$ind_lb}}" data-ids="{{$ind_lb}}" class="form-control id_provinsi" onchange="changeProvinsi({{$ind_lb}})">
                                            <option value="0" @if($item->id_provinsi == "0") "selected" @endif>Pilih Provinsi</option>
                                            @foreach($all_provinsi as $itm_provinsi)
                                                <option value="{{$itm_provinsi->id_provinsi}}" @if($item->id_provinsi == $itm_provinsi->id_provinsi) "selected" @endif>{{$itm_provinsi->nama_provinsi}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Site</label>
                                        <select name="id_site[]" id="id_site_{{$ind_lb}}" class="form-control id_site" multiple="multiple">
                                            @foreach($all_site[$ind_lb] as $itm_site)
                                            
                                                <option value="{{$itm_site->site_id}}" @if(in_array($itm_site->site_id, $myArraySite)) "selected" @endif>{{$itm_site->sitename}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-1">
                                    <a class="mx-2" onclick="removeDiv({{$ind_lb}})"><i class="fas fa-trash btn-remove" aria-hidden="true"></i></a>
                                </div>
                            </div>
                            <?php
                            $ind_lb++;
                            ?>
                        @endforeach
                    
                    @else
                        <div class="row" id="row_brand_site_0">
                            <div class="col-11 row">
                                <div class="form-group col-md-4">
                                    <label>Brand</label>
                                    <select name="id_brand[]" id="id_brand_0" data-ids="0" onchange="changeBrand(0)" class="form-control id_brand">
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label>Province</label>
                                    <select name="id_provinsi[]" id="id_provinsi_0" data-ids="0" class="form-control id_provinsi" onchange="changeProvinsi(0)">
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label>Site</label>
                                    <select name="id_site[]" id="id_site_0" class="form-control id_site" multiple="multiple">
                                    </select>
                                </div>
                            </div>
                            <div class="col-1">
                                <a class="mx-2" onclick="removeDiv(0)"><i class="fas fa-trash btn-remove" aria-hidden="true"></i></a>
                            </div>
                        </div>
                    @endif



                </div>
                <button type="button" class="btn btn-outline-secondary btn-sm" id="btn_add_brand">Tambah Brand</button>
            </div>
            <div class="form-group">
                <button type="submit" id="submitUser" class="btn btn-primary">Ubah</button>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="notifInvalid" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Error</h5>
                <button type="button" class="close notifInvalidClose" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Duplicate Username!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary notifInvalidClose" data-dismiss="modal">Ok</button>
            </div>
        </div>
    </div>
</div>
<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
@endsection
@push('js')
    <script src="{{ asset('/') }}assets/vendor/js//bootstrap.bundle.min.js"
            crossorigin="anonymous">
    </script>
    <script src="{{ asset('/') }}assets/vendor/js//bootstrap-multiselect.js" type="text/javascript">
    </script>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $('.notifInvalidClose').click(function () {
            $('#notifInvalid').modal('hide');
        });
        var id_level = {{$data->id_level}};

        var ind_inp = {{$startInd}};
        var ind_tp = {{$startInd}};
        $('#btn_add_brand').click(function () {
            var html = '<div class="row" id="row_brand_site_' + ind_inp + '"><div class="col-11 row"><div class="form-group col-md-4"><label> Brand</label><select name="id_brand[]" id="id_brand_' + ind_inp + '" data-ids="' + ind_inp + '" class="form-control id_brand" onchange="changeBrand(' + ind_inp + ')"></select></div >';
            html += '<div class="form-group col-md-4"><label> Province</label><select name="id_provinsi[]" id="id_provinsi_' + ind_inp + '" data-ids="' + ind_inp + '" class="form-control id_provinsi"></select></div >';
            html += '<div class="form-group col-md-4"><label> Site</label><select name="id_site[]" id="id_site_' + ind_inp + '" class="form-control id_site" multiple="multiple"></select></div >';
            html += '</div><div class="col-1"><a class="mx-2" onclick="removeDiv(' + ind_inp + ')"><i class="fas fa-trash btn-remove" aria-hidden="true"></i></a></div></div>';
            $('#list_brand').append(html);
            load_data_select(ind_inp, 1);
            load_data_provinsi(ind_inp, 0);
            $('#id_site_' + ind_inp).select2();
            ind_inp++;
        });

        function load_data_select(ind_dt,id) {
            var request = $.ajax({
                url: "{{url('brand/CariBrandAll')}}" + "/"+id,
                method: "GET",
                dataType: "json",
                success: function (result) {
                    $('#id_brand_' + ind_dt).append("<option value=''>Pilih Brand</option>");
                    for (var i = 0; i < result.length; i++) {
                        $('#id_brand_' + ind_dt).append("<option value='" + result[i].id_brand + "'>" + result[i].nama_brand +"</option>");
                    }
                }
            });
        }
        function load_data_provinsi(ind_dt,id) {
            var request = $.ajax({
                url: "{{url('user/cari-provinsi')}}" + "/"+id,
                method: "GET",
                dataType: "json",
                success: function (result) {
                    $('#id_provinsi_' + ind_dt).append("<option value='0'>Pilih Provinsi</option>");
                    for (var i = 0; i < result.length; i++) {
                        $('#id_provinsi_' + ind_dt).append("<option value='" + result[i].id_provinsi + "'>" + result[i].nama_provinsi +"</option>");
                    }
                }
            });
        }
        function AjaxSite(id_ind,tipe) {
            $('#id_site_' + id_ind).html("");
            if (tipe == 1) {
                var url = "{{url('site/CariSiteAll')}}" + "/" + $("#id_brand_" + id_ind).val();
            } else {
                var url = "{{url('site/CariSiteAllV2')}}" + "/" + $("#id_brand_" + id_ind).val() + "/" + $("#id_provinsi_" + id_ind).val();
            }
            var request = $.ajax({
                url: url,
                method: "GET",
                dataType: "json",
                success: function (result) {
                    for (var i = 0; i < result.length; i++) {
                        $('#id_site_' + id_ind).append("<option value='" + result[i].site_id + "'>" + result[i].sitename +"</option>");
                    }
                    $('#id_site_' + id_ind).select2();
                }
            });
        }
       /* $('.id_brand').change(function (e) {
            if ($(this).val() != '') {
                console.log('ids',$(this).data('ids'));
                AjaxSite($(this).data('ids'));
            }

        });*/
        function changeBrand(ids) {
            if ($('#id_brand_' + ids).val() != '') {
                //console.log('ids', $('#id_brand_' + ids).data('ids'));
                if ($('#id_provinsi_' + ids).val() != 0) {
                    AjaxSite($('#id_brand_' + ids).data('ids'), 2);
                } else {
                    AjaxSite($('#id_brand_' + ids).data('ids'), 1);
                }

            }
        }
        function changeProvinsi(ids) {
            if ($('#id_brand_' + ids).val() != '') {
                if ($('#id_provinsi_' + ids).val() != 0) {
                    AjaxSite($('#id_brand_' + ids).data('ids'), 2);
                } else {
                    AjaxSite($('#id_brand_' + ids).data('ids'), 1);
                }
            }
        }
        function removeDiv(ids) {
            $('#row_brand_site_' + ids).remove();
        }
        $(document).ready(function () {
            for (i = 0; i < ind_tp; i++) {
                $('#id_site_' + i).select2();
            }
        });

        if (id_level != 4) {
            $('#list_brand').hide();
            load_data_select(0, 0);
            load_data_provinsi(0, 0);
            $('#btn_add_brand').hide();
        }
        $('#id_level').change(function (e) {
            if ($('#id_level').val() != '4') {
                $('#list_brand').hide();
                $('#btn_add_brand').hide();
            } else {
                $('#list_brand').show();
                $('#btn_add_brand').show();
            }
        });
        $("#formUser").submit(function (e) {
            e.preventDefault();
            $('#submitUser').attr('disabled', true);
            var arr_brand = [];
            var arr_site = [];
            var arr_provinsi = [];
            $('.id_site').each(function () {
                arr_site.push($(this).val());
            });
            $('.id_brand').each(function () {
                arr_brand.push($(this).val());
            });
            $('.id_provinsi').each(function () {
                arr_provinsi.push($(this).val());
            });
            var data = new FormData();
            data.append('name', $('#name').val());
            data.append('username', $('#username').val());
            data.append('password', $('#password').val());
            data.append('id_level', $('#id_level').val());
            data.append('id_site', JSON.stringify(arr_site));
            data.append('id_brand', JSON.stringify(arr_brand));
            data.append('id_user', $('#id').val());
            data.append('id_provinsi', JSON.stringify(arr_provinsi));
            $.ajax({
                type: "POST",
                url: "{{url('user/save-edit')}}", // Replace with your server endpoint
                enctype: 'multipart/form-data',
                processData: false,
                contentType: false,
                data: data,
                success: function (response) {
                    // Handle the response from the server
                    console.log(response);
                    $('#submitUser').attr('disabled', false);
                    if (response.Code == 1) {
                        window.location = "{{url('user')}}";
                    } else {
                        $('#notifInvalid').modal('show');
                    }
                },
                error: function (error) {
                    // Handle errors
                    console.log(error);
                }
            });
        });
</script>
@endpush