@push('css-app')
<style>
    .select2-container {
        width: 100% !important;
    }

    .select2-container--default.select2-container--focus .select2-selection--multiple {
        border: 1px solid #d1d3e2;
        min-height: calc(1.5em + 0.75rem + 5px);
        border-radius: 0.35rem;
    }

    .select2-container--default .select2-selection--multiple {
        border: 1px solid #d1d3e2;
        min-height: calc(1.5em + 0.75rem + 5px);
        border-radius: 0.35rem;
    }

    .select2-selection {
        overflow-y: auto;
        white-space: nowrap;
        -ms-overflow-style: none; /* IE and Edge */
        scrollbar-width: none; /* Firefox */
    }

        .select2-selection::-webkit-scrollbar {
            display: none;
        }

    ul.select2-selection__rendered {
        white-space: nowrap;
    }
</style>
@endpush
@extends('template')
@section('content')
<?php use App\Http\Traits\Helper; ?>
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card border-0  my-2">
    <div class="card-body">
        <form action="{{url('user/save-password')}}" method="post">
            @csrf
            <input type="hidden" name="id" value="{{$data->id}}">
            <div class="form-group">
                <label>Old Password  <small class="text-danger" id="old_password_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> old password didn't match</small></label>
                <input type="password" id="old_password" name="old_password" class="form-control" />
            </div>
            <div class="form-group">
                <label>New Password</label>
                <input type="password" name="password" id="password" class="form-control" />
            </div>
            <div class="form-group">
                <label>Confirm Password  <small class="text-danger" id="confirm_password_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> password didn't match</small></label>
                <input type="password" name="confirm_password" id="confirm_password" class="form-control" />
            </div>
            
            <div class="form-group">
                <button type="submit" id="btn_submit" class="btn btn-primary" disabled="true">Simpan</button>
            </div>
        </form>
    </div>
</div>

<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
@endsection
@push('js')

<script>
   function cekPassword() {
        if ($('#old_password').val() == "@ViewBag.password") {
            $('#old_password_cek').hide();
            if ($('#password').val() != "") {
                if ($('#password').val() == $('#confirm_password').val()) {
                    $('#confirm_password_cek').hide();
                    $('#btn_submit').attr('disabled', false);
                } else {
                    $('#confirm_password_cek').show();
                }
            }
        } else {
            $('#old_password_cek').show();
        }
    }
    
    $('#old_password').blur(function () {
        cekPassword();
    });
    $('#password').blur(function () {
        cekPassword();
    });
    $('#confirm_password').blur(function () {
        cekPassword();
    });
    var typingTimer;                //timer identifier
    var doneTypingInterval = 500;  //time in ms, 5 seconds for example
    var $input = $('#confirm_password');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(doneTyping, doneTypingInterval);
    });

    //on keydown, clear the countdown 
    $input.on('keydown', function () {
        clearTimeout(typingTimer);
    });

    //user is "finished typing," do something
    function doneTyping() {
        //do something
        cekPassword();
    }
</script>
@endpush