@push('css-app')
<style>

</style>
@endpush
@extends('template')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card border-0  my-2">
    <div class="card-body">
        <form id="formSite" method="post">
            <div class="form-group">
                <label>Site Name</label>
                <input type="text" name="sitename" id="sitename" class="form-control" />
            </div>
            <div class="form-group">
                <label>Site Code  <small class="text-danger" id="site_code_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Invalid Site Code</small></label>
                <input type="text" name="site_code" id="site_code" class="form-control" />
            </div>
            <div class="form-group">
                <label>Division ID</label>
                <input type="text" name="divison_id" id="divison_id" class="form-control" />
            </div>
            <div class="form-group">
                <label>Site Key  <small class="text-danger" id="key_outlet_cek" style="display:none;"><i class="fas fa-exclamation-circle" aria-hidden="true"></i> Invalid Site Key</small></label>
                <input type="text" name="key_outlet" id="key_outlet" class="form-control" />
            </div>
            <div class="form-group">
                <label>Location ID</label>
                <input type="text" name="location_id" id="location_id" class="form-control" />
            </div>
            <div class="form-group">
                <label>Brand</label>
                <select id="id_brand" name="id_brand" id="id_brand" class="form-control">
                    @foreach ($brand as $item)
                        <option value="{{$item->id_brand}}">{{$item->nama_brand}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>Province</label>
                <select id="id_provinsi" name="id_provinsi" id="id_provinsi" class="form-control">
                    <option value="0">Choose Province</option>
                    @foreach ($provinsi as $item)
                        <option value="{{$item->id_provinsi}}">{{$item->nama_provinsi}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>City</label>
                <select id="id_kota" name="id_kota" id="id_kota" class="form-control">
                </select>
            </div>
            <div class="form-group">
                <button type="submit" id="submit_btn" class="btn btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="notifInvalid" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Error</h5>
                <button type="button" class="close notifInvalidClose" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="text_notif">Duplicate Site Code or Duplicate Key!</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary notifInvalidClose" data-dismiss="modal">Ok</button>
            </div>
        </div>
    </div>
</div>

<!-- <script rc="https://cdn.jsdelivr.net/npm/chart.js@4.0.1/dist/chart.umd.min.js"></script> -->
@endsection
@push('js')

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $('.notifInvalidClose').click(function () {
        $('#notifInvalid').modal('hide');
    });
    base_url = '@ViewBag.url';
    $('#id_provinsi').change(function (e) {
        AjaxKota();
    });
    function AjaxKota() {
        $('#id_kota').html("");
        var request = $.ajax({
            url: "{{url('site/CariKotaAll')}}" + "/" + $("#id_provinsi").val(),
            method: "GET",
            dataType: "json",
            success: function (result) {
                for (var i = 0; i < result.length; i++) {
                    $("#id_kota").append("<option value='" + result[i].id_kota + "'>" + result[i].nama_kota +"</option>");
                }
            }
        });
    }
    function cekSite() {
        var data = new FormData();
        data.append('site_key', $('#key_outlet').val());
        data.append('site_code', $('#site_code').val());
        data.append('site_name', $('#sitename').val());
        data.append('site_id', 0);
        $.ajax({
            url: "{{url('site/cekSiteKey')}}",
            method: "POST",
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            data: data,
            dataType: "json",
            success: function (result) {

                if (result.cek_name) {
                    if (result.cek_site) {
                        if (result.cek_key) {
                            do_ajax();
                        } else {
                            $('#notifInvalid').modal('show');
                            $('#text_notif').html('Duplicate/Wrong Key!');
                            $('#submit_btn').attr('disabled', false);
                        }
                    } else {
                        $('#notifInvalid').modal('show');
                        $('#text_notif').html('Duplicate Site Code');
                        $('#submit_btn').attr('disabled', false);
                    }
                } else {
                    $('#notifInvalid').modal('show');
                    $('#text_notif').html('Duplicate/Empty Sitename');
                    $('#submit_btn').attr('disabled', false);
                }

            }
        });
    }
    function do_ajax() {
        //var data = $('#formSite').serialize();
        var data = new FormData();
        data.append('sitename', $('#sitename').val());
        data.append('site_code', $('#site_code').val());
        data.append('divison_id', $('#divison_id').val());
        data.append('key_outlet', $('#key_outlet').val());
        data.append('id_brand', $('#id_brand').val());
        data.append('id_provinsi', $('#id_provinsi').val());
        data.append('id_kota', $('#id_kota').val());
        data.append('location_id', $('#location_id').val());
        $.ajax({
            type: "POST",
            url: "{{url('site/save')}}", // Replace with your server endpoint
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            data: data,
            success: function (response) {
                // Handle the response from the server
                console.log(response);
                $('#submit_btn').attr('disabled', false);
                window.location = "{{url('site')}}";
            },
            error: function (error) {
                // Handle errors
                console.log(error);
            }
        });
    }
    $("#formSite").submit(function (e) {
        e.preventDefault();
        $('#submit_btn').attr('disabled', true);
        cekSite();
    });
   
</script>
@endpush