<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>PAJA - Pawang Jalan</title>
    <link rel="icon" type="image/x-icon" href="{{asset('assets/img/paja_logo_2.png')}}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link href='https://fonts.googleapis.com/css?family=Inter' rel='stylesheet'>
    <style>
      .home-bg{
         /* The image used */
        background-image: url("{{asset('assets/img/landing/bg_1.jpg')}}");
        
        /* Full height */
        height: 100%;
        min-height: 100vh;

        /* Create the parallax scrolling effect */
        background-attachment: fixed;
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        
      }

      .hm-ts{
        display: flex;
        transform: translateY(0%);
        transition: all 0.4s ease-in-out;
        position: absolute;
        top: 0;
        right: 0;
        bottom: auto;
        left: 0;
        opacity: 1;
        z-index: 1040;
        padding: 2rem 0;
        align-items: center;
      }
      .container{
        display: flex;
        flex-wrap: inherit;
        align-items: center;
        justify-content: space-between;
      }
      .navbar-collapse {
        display: flex !important;
        flex-basis: auto;
        flex-grow: 1;
        align-items: center;
      }
      .navbar-nav{
        flex-direction: row;
      }
      .navbar-brand {
        font-family: 'Inter';
        padding-top: .40625rem;
        padding-bottom: .40625rem;
        margin-right: 19rem;
        font-style: normal;
        font-weight: 700;
        font-size: 37px;
        /* line-height: 45px; */
        white-space: nowrap;
      }

      .logo-img{
        max-width: 9rem;
        height: auto;
      }

      .navbar-nav .nav-link {
        font-family: 'Inter';
        padding-left: 1rem !important;
        padding-right: 1rem !important;
        color: #D3D3D4;
        text-shadow: 0 0 32px rgba(0,0,0,0.5);
        font-weight: 600;
        font-size: 17px;
        line-height: 17px;
      }
      .home-content{
        position: absolute;
        left: 0;
        top: 50%;
        width: 100%;
        text-align: center;
        
      }
      .home-txt{
        font-family: 'Inter';
        color: #fff;
        font-weight: 600;
        font-size: 33px;
        line-height: 38px;
        width: 55vw;
        display: block;
        padding-left: 10vw;
        text-align: left;
        /* padding: 3vw;
          background-color: #0000006e;
          margin-left: 8vw;
        */
      }

      .btn-home{
        width: 164px;
        height: 44px;
        background: #3aa779;
        border-radius: 53px;
        font-family: 'Inter';
        font-style: normal;
        font-weight: 500;
        font-size: 18px;
        line-height: 22px;
        color: #FFFFFF;
        border: 0;
      }

      .ck-row{
        max-width: 100%;
        height: 100vh;
        padding-top:5rem;
      }
      .ck-col-img{

      }
      
      .ck-img{
        margin-right: 5rem !important;
        margin-left:12rem;
        width: 25rem;
        height: auto;
      }

      .ck-col-txt{
        padding-left: 6rem;
        padding-right: 10rem;
      }

      .ck-title-1{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        font-size: 24px;
        line-height: 24px;
        color:#EB834F;
        margin-bottom: 2rem;
      }

      .ck-title-2{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        font-size: 45px;
        line-height: 52px;
        color: #000000;
        margin-bottom: 2rem;
      }

      .ck-txt{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 500;
        font-size: 20px;
        line-height: 22px;
        color: #9698A0;
        margin-bottom: 2rem;
      }

      .ck-ul{
        list-style-image: url("{{asset('assets/img/landing/dot_2.png')}}");
      }
      .ck-li{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 500;
        font-size: 20px;
        line-height: 22px;
        margin-bottom: 1.6rem;
        color: #000000;
      }

      /*statistik*/
      .sk-title-1{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        font-size: 24px;
        line-height: 24px;
        color:#EB834F;
        margin-bottom: 2rem;
        padding-top: 5rem;
        text-align: center;
      }

      .sk-title-2{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        font-size: 45px;
        line-height: 52px;
        color: #000000;
        margin-bottom: 2rem;
        text-align: center;
      }

      .sk-txt{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 500;
        font-size: 20px;
        line-height: 22px;
        color: #9698A0;
        margin-bottom: 2rem;
        text-align: center;
        padding-left: 20rem;
        padding-right: 20rem;
      }

      .sk-box{
        background-color: #fff; 
        padding: 20px; 
        box-shadow: 0px 4px 4px rgba(121, 133, 148, 0.25);
        text-align: center;
        margin-bottom: 15px;
        width: 17rem;
        height: 12rem;
        justify-content: center;
        display: grid;
      }

      .sk-box-title{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 700;
        font-size: 50px;
        line-height: 61px;

        color: #000000;
      }

      .sk-box-text{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 500;
        font-size: 24px;
        line-height: 29px;
        text-align: center;

        color: #81838F;
      }

      .sk-img-right{
        height: auto;
      }

      /*Jenis Kerusakan*/
      .jk-title{
        font-family: 'Inter';
        font-size: 30px;
        font-weight: 700;
        line-height: 34px;
        color: #000000;
        text-align: center;
        padding-top: 3rem;
        margin-bottom: 2.5rem;
        z-index: 2;
        position: relative;
      }

      .jk-box{
        width: 136px;
        height: auto;
        margin: 1rem;
      }

      .jk-img{
        width: 136px;
        height: 136px;
        border-radius: 50%;
      }

      .jk-txt{
        font-family: 'Inter';
        text-align: center;
        font-weight: 700;
        font-size:14px;
        
      }

      .jk-title-2{
        font-family: 'Inter';
        font-style: normal;
        font-weight: 600;
        font-size: 20px;
        line-height: 24px;
        color:#EB834F;
        text-align: center;
        padding-top: 3rem;
      }

      /*footer*/
      .nav-link{
        padding:0px;
        padding-left: 1rem;
        color: #fff;
        font-family: 'Inter';
        font-size: 15px;
      }
    </style>
  </head>
  <body style="overflow-x:hidden;">
    <section class="home" id="home">
      <!-- <div class="home-header">
        <header class="mb-auto">
          <div style="position: relative;padding-top:100px">
            <h3 class="float-md-start mb-0">RRD</h3>
            <nav class="nav nav-masthead justify-content-center float-md-start">
              <a class="nav-link active" aria-current="page" href="#">Home</a>
              <a class="nav-link" href="#">Cara Kerja</a>
              <a class="nav-link" href="#">Statistik</a>
              <a class="nav-link" href="#">Jenis Kerusakan</a>
            </nav>
          </div>
        </header>
      </div> -->
      <nav class="hm-ts">
        <div class="container">
          <a href="#home" class="navbar-brand"><img class="logo-img" src="{{asset('assets/img/landing/logo.png')}}" alt="Logo"></a>
          <!-- <a href="#home" class="navbar-brand">
            <div class="logo">
              <span style="color: #FDFDFD;">SKY</span><span style="color: #63E7ED;">FLY</span>
            </div>
          </a> -->

          <!-- primary -->
          <div class="collapse navbar-collapse" id="navbar" data-bs-parent="#mainNav">
            <ul class="navbar-nav">
              <li class="nav-item">
                <a class="nav-link" href="#home" id="navbarDropdown-1" role="button" >
                  Home
                </a>
              </li>
              <li class="nav-item">
                <a class="nav-link" href="#cara_kerja" id="navbarDropdown-2" role="button" >
                  Cara Kerja
                </a>
                
              </li>
              <li class="nav-item">
                <a class="nav-link" href="#statistik" id="navbarDropdown-3" role="button">
                  Statistik
                </a>
                
              </li>
              <li class="nav-item">
                <a class="nav-link" href="#jenis_kerusakan" id="navbarDropdown-4" role="button">
                  Jenis Kerusakan
                </a>
                
              </li>
            </ul>
          </div>
          <div>
            <button class="btn-home" onclick="location.href='{{url("login")}}';">Login</button>
            <!-- <a href="/login" class="button">Go to Google</a> -->
          </div>
        </div>
      </nav>
      <div class="home-bg">
        <div style="background-color: #0000006e;min-height: 100vh;">
        </div>
        <div class="home-content">
          <span class="home-txt">
            Pemanfaatan Teknologi Artificial Intelligence (AI) untuk mempercepat proses survey Jalan di Indonesia. Cepat, Akurat dan Teruji
          </span>
        </div>    
      </div>
    </section>
    <section class="cara-kerja" id="cara_kerja">
      <div class="row ck-row">
        <div class="ck-col-img col-5">
          <img src="{{asset('assets/img/landing/cara_kerja_3.png')}}" class="ck-img ">
        </div>
        <div class="col-7 ck-col-txt">
          <div class="ck-title-1">
            HOW ITS WORK
          </div>
          <div class="ck-title-2">
            Tinggalkan cara lama untuk melakukan analisa kerusakan jalan
          </div>
          <div class="ck-txt">
            PAJA menawarkan efisiensi dan akurasi dalam proses analisa kerusakan jalan. Data diproses menggunakan teknologi AI serta tersimpan dalam database cloud sehingga dapat dilihat kapan saja dan dari mana saja 
          </div>
          <div>
            <ul class="ck-ul">
              <li class="ck-li">Daftar sekarang juga cukup menggunakan akun email yang Anda miliki</li>
              <li class="ck-li">Ikuti petunjuk di dalam dashboard setelah Anda berhasil melakukan registrasi</li>
              <li class="ck-li">Buktikan teknologi PAJA benar benar bisa membantu Anda</li>
            </ul>
          </div>
        </div>
      </div>
    </section>
    <section class="statistik" id="statistik">
      <div class="sk-title-1">
        OUR STATISTICS
      </div>
      <div class="sk-title-2">
        Kami bangga bersama Anda
      </div>
      <div class="sk-txt">
        Data berikut kami tampilkan secara realtime berdasarkan data yang sudah di submit dan di proses oleh pengguna PAJA
      </div>
      <div class="row" style="border:0px;margin-right:0;margin-left:0;max-width:100%;padding-bottom: 11rem;">
        <div class="col-6">
          <div class="container">
            <div class="row">
              <div class="col-6">
                <div class="sk-box float-md-end">
                    <div class="sk-box-title">{{$provinsi}}</div>
                    <div class="sk-box-text">Provinsi</div>
                    <div style="font-size: 1rem; color: #64748B;">
                            Sudah dianalisa
                    </div>
                </div>
              </div>
              <div class="col-6">
                  <div class="sk-box">
                      <div class="sk-box-title">{{$kota}}</div>
                      <div class="sk-box-text">Kota</div>
                      <div style="font-size: 1rem; color: #64748B;">
                            Sudah dianalisa
                      </div>
                  </div>
              </div>
              <div class="col-6">
                <div class="sk-box float-md-end">
                    <div class="sk-box-title">{{$ruas}}</div>
                    <div class="sk-box-text">Ruas Jalan</div>
                    <div style="font-size: 1rem; color: #64748B;">
                            Sudah dianalisa
                    </div>
                </div>
              </div>
              <div class="col-6">
                  <div class="sk-box">
                      <div class="sk-box-title">{{$objek}}</div>
                      <div class="sk-box-text">Analisa</div>
                      <div style="font-size: 1rem; color: #64748B;">
                            Sudah dibuat
                      </div>
                  </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-6">
          <img class="sk-img-right" src="{{asset('assets/img/landing/statistik_img.png')}}">
        </div>
      </div>
    </section>
    <section class="jenis-kerusakan" id="jenis_kerusakan" style="background-color: #FDFEF6;">
      <div style="background-color: #3aa779;width:135px;height:25px;position: relative;left: 49vw;top: 9.5vh;z-index: 1;"></div>
      <div class="jk-title">
        Jenis Kerusakan
      </div>
      
      <div style="padding-left: 25rem;padding-right: 25rem;padding-bottom: 8rem;text-align: center;">
        <div style="display: inline-flex;">
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/retak_buaya.jpeg')}}">
            <div class="jk-txt">Retak Buaya</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/retak_melintang.jpeg')}}">
            <div class="jk-txt">Retak Melintang</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/retak_memanjang.jpeg')}}">
            <div class="jk-txt">Retak Memanjang</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/lubang.jpg')}}">
            <div class="jk-txt">Lubang</div>
          </div>
        </div>
        <!-- <div style="display: inline-flex;">
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/jenis_kerusakan_5.png')}}">
            <div class="jk-txt">Louis Le</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/jenis_kerusakan_6.png')}}">
            <div class="jk-txt">Sana Ali</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/jenis_kerusakan_7.png')}}">
            <div class="jk-txt">Allen Geiger</div>
          </div>
          <div class="jk-box">
            <img class="jk-img" src="{{asset('assets/img/landing/jenis_kerusakan_8.png')}}">
            <div class="jk-txt">Jeffry Mcgarry</div>
          </div>
        </div> -->
        <div class="jk-title-2">
          Dan akan terus bertambah sesuai dengan peraturan perundang undangan
        </div>
      </div>
      
    </section>
    <footer>

      <div style="background-color: #121212;text-align: center;padding-left: 30rem;padding-right: 30rem;">
        <div style="color:#fff;font-size:39px;line-height: 46px;font-weight: 600;font-family: 'Inter';padding-top:5rem;margin-bottom: 1rem;">
          Pawang Jalan (PAJA)
        </div>
        <div style="color:#fff;font-size:15px;line-height: 16px;font-weight: 400;font-family: 'Inter';padding-bottom:5rem">
          Solusi berbasis Kecerdasan Buatan (AI) untuk membantu pelaku survey jalan di Indonesia dalam melakukan efisiensi waktu serta akurasi analisa kerusakan Jalan. PAJA dikembangkan oleh anak bangsa sesuai dengan kebutuhan survey jalan di Indonesia
        </div>
      </div>
      <div class="row" style="background-color: #000000;padding-left: 1rem;padding-right: 1rem;padding-top: 1.1rem;padding-bottom: 1.1rem;border:0px;margin-right:0;margin-left:0;max-width:100%;">
        <div class="col-6" style="color: #fff;font-family: 'Inter';font-size: 15px;">Copyright&#169;2023 <span style="color: #3aa779">PAJA Team</span></div>
        <div class="col-6">
          <nav class="nav nav-masthead justify-content-center float-md-end">
            <a class="nav-link active" aria-current="page" href="#home">Home</a>
            <a class="nav-link" href="#cara_kerja">Cara Kerja</a>
            <a class="nav-link" href="#statistik">Statistik</a>
            <a class="nav-link" href="#jenis_kerusakan">Jenis Kerusakan</a>
          </nav>
        </div>
      </div>
    </footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
    <script src="{{ asset('/') }}assets/vendor/jquery/jquery.min.js"></script>
    <script>
      $(document).on('click', 'a[href^="#"]', function (event) {
          event.preventDefault();

          $('html, body').animate({
              scrollTop: $($.attr(this, 'href')).offset().top
          }, 750);
      });
    </script>
  </body>
</html>
