﻿var table;
(function ($) {
    $.fn.AppTable = function (obj) {
        return this.DataTable({
            processing: true,
            serverSide: true,
            ajax: obj.url,
            method:"GET",
            columns: obj.column,
            dataSrc: 'data',
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]]

        });
    };
})(jQuery);
function refresh_table() {
    if (table) {
        table.ajax.reload();
    }
}
$(document).on('click', '.deleteRow', function (e) {
    e.preventDefault();

    Swal.fire({
        title: 'Apakah anda yakin?',
        text: "anda tidak bisa membatalkan perintah ini!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Hapus'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: "GET",
                url: $(this).attr('href'),
                success: function (e) {
                    Swal.fire(
                        'Terhapus!',
                        'Data berhasil di hapus.',
                        'success'
                    )
                    refresh_table();
                }
            });
        }
    })
    
    
})

function submitdata(obj) {
    obj.btn_old_name = obj.DisabledButton[0].innerText;
    obj.DisabledButton.attr("disabled", true);
    obj.DisabledButton.text("Tunggu Sebentar..");
    $.ajax({
        xhr: function () {
            var xhr = new window.XMLHttpRequest();

            xhr.upload.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    var percentComplete = evt.loaded / evt.total;
                    percentComplete = parseInt(percentComplete * 100);
                    $('.progress-bar').width(percentComplete + '%');
                    $('.progress-bar').html(percentComplete + '%');
                   

                }
            }, false);

            return xhr;
        },
        type: obj.type,
        url: obj.url,
        data: new FormData(obj.data),
        dataType: "json",
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.code == 1) {
                Swal.fire(
                    'Tersimpan!',
                    'Data berhasil disimpan.',
                    'success'
                ).then((result) => {
                    if (obj.refresh_page) {
                        window.location.replace(obj.refresh_page);
                    }
                });
            } else {

                Swal.fire({
                    title: 'Peringatan!',
                    text: response.messages,
                    type: 'warning',
                }).then((result) => {

                    // console.log(obj.btn_old+" haha2");
                    obj.DisabledButton.attr("disabled", false);
                    obj.DisabledButton.text(obj.btn_old_name);

                });

            }
        },
        error: function (data) {
            obj.DisabledButton.attr("disabled", false);
            obj.DisabledButton.text("Simpan");
            
        }
    });
}