<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class MSite extends Model
{
    use HasFactory;

    protected $table = "m_site";
    protected $primaryKey = 'site_id';
    public $timestamps = false;
    protected $fillable = [
    ];
    public static function checkExist($id)
    {
        return self::where('site_id',$id);
    }

    public static function selectDataTables($site_id,$site_code){
        $query = DB::table('m_site')->where('deleted',1);
        if($site_id != 0){
            $query->where('site_id',$site_id);
        }
        if($site_code != '' && $site_code != null){
            $query->where('site_code',$site_code);
        }
        return $query;
    }

    public static function selectDataTables_1($site_id, $site_code, $start, $length, $search, $sort, $sort_direction,$store_availibility){
        $query = "SELECT m_site.* from m_site";
        $query .= " where m_site.deleted = 1";
        if ($site_id != 0)
        {
            $query .= " and m_site.site_id = ".$site_id;
        }
        if($site_code != '' && $site_code != null){
            $query .= " and m_site.site_code = '".$site_code."'";
        }
        if($store_availibility != 'all'){
            $query .= " and m_site.store_availibility = ".$store_availibility;
        }
        //dd($search);
        if ($search != null && $search !='')
        {
            $query .= " AND sitename LIKE '%".$search."%'";
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != '')
        {
            $query .= " ORDER BY " . $sort . " " . $sort_direction;
        }
        //query += " LIMIT " + length + " OFFSET " + start;
        if ($length > 0)
        {
            $query .= " LIMIT " . $length;
            $query .= " OFFSET " . $start;
            
        }
        return DB::select($query);
    }

    public static function selectDataTables_2($site_id, $start, $length, $search, $sort, $sort_direction,$store_availibility){
        $query = DB::table('m_site')->where('deleted',1)->whereIn('site_id',$site_id);
        if ($search != null && $search !='')
        {
            $query->where('site_name', 'like', '%'.$search.'%');
        }
        if($store_availibility != 'all'){
            $query->where('store_availibility', $store_availibility);
        }
        if ($sort != null && $sort != '' && $sort_direction != null && $sort_direction != ''){
            $query->orderBy($sort,$sort_direction);
        }
        if ($length > 0)
        {
            $query->offset($start)->limit($length);
        }
        return $query;
    }

    public static function TotalData_1($site_id, $site_code,$search,$store_availibility){
        $query = "SELECT count(*) from m_site";
        $query .= " where m_site.deleted = 1";
        if ($site_id != 0)
        {
            $query .= " and m_site.site_id = ".$site_id;
        }
        if($site_code != '' && $site_code != null){
            $query .= " and m_site.site_code = '".$site_code."'";
        }
        if($store_availibility != 'all'){
            $query .= " and m_site.store_availibility = ".$store_availibility;
        }
        //dd($search);
        if ($search != null && $search !='')
        {
            $query .= " AND sitename LIKE '%".$search."%'";
        }
        
        return DB::select($query);
    }
    public static function TotalData_2($site_id, $site_code,$search,$store_availibility){
        $query = DB::table('m_site')->where('deleted',1)->whereIn('site_id',$site_id);
        if ($search != null && $search !='')
        {
            $query->where('site_name', 'like', '%'.$search.'%');
        }
        if($store_availibility != 'all'){
            $query->where('store_availibility', $store_availibility);
        }
        return $query->count();
    }
    public static function select_q($site_id,$site_code){
        $query = "SELECT m_site.*,map_site_brand.id_brand from m_site";
        $query .= " left join map_site_brand on map_site_brand.id_site = m_site.site_id";
        $query .= " where deleted = 1";
        if ($site_id != 0)
        {
            $query .= " and m_site.site_id = ".$site_id;
        }
        if($site_code != '' && $site_code != null){
            $query .= " and m_site.site_code = '".$site_code."'";
        }
        return DB::select($query);
    }
    public static function insert_q($arr_data){
        $id = DB::table('m_site')->insertGetId($arr_data, 'site_id');
        return $id;
    }
    public static function insertApi($arr_data){
        $id = DB::table('m_site')->insertGetId($arr_data, 'site_id');
        return $id;
    }
    public static function insertExcel($arr_data){
        $id = DB::table('m_site')->insertGetId($arr_data, 'site_id');
        return $id;
    }
    public static function TotalData($site_code){
        $query = "SELECT count(*) from m_site";
        $query .= " where m_site.deleted = 1";
        if($site_code != '' && $site_code != null){
            $query .= " and m_site.site_code = '".$site_code."'";
        }
        return DB::select($query);
    }
    public static function cekSitename($sitename,$site_id){
        $query = "SELECT count(*) from m_site";
        $query .= " where m_site.deleted = 1";
        if($sitename != '' && $sitename != null){
            $query .= " and m_site.sitename = '".$sitename."'";
        }
        if ($site_id != 0)
        {
            $query .= " and m_site.site_id != ".$site_id;
        }
        return DB::select($query);
    }
    public static function cekSiteKey($site_code,$site_id){
        $query = "SELECT count(*) from m_site";
        $query .= " where m_site.deleted = 1";
        if ($site_id != 0)
        {
            $query .= " and m_site.site_id != ".$site_id;
        }
        if($site_code != '' && $site_code != null){
            $query .= " and m_site.site_code = '".$site_code."'";
        }
        return DB::select($query);
    }
    public static function update_q($id,$arr_data){
        DB::table('m_site')->where('site_id', $id)->update($arr_data);
        return true;
    }
    public static function delete_q($id){
        DB::table('m_site')->where('site_id', $id)->update(['deleted'=>0]);
        return true;
    }
    public static function insertMapSB($arr_data){
        $id = DB::table('map_site_brand')->insertGetId($arr_data, 'id');
        return $id;
    }
    public static function updateMapSB($arr_data){
        DB::table('map_site_brand')->where('id_site', $arr_data['id_site'])->update(['id_brand'=>$arr_data['id_brand']]);
        return true;
    }
    public static function TotalDataMapSB($id_site){
        $query = DB::table('map_site_brand');
        if($id_site != 0){
            $query->where('id_site', $id_site);
        }
        return $query->count();
    }
    public static function DeleteMapSB($id_site){
        $query = DB::table('map_site_brand');
        if($id_site != 0){
            $query->where('id_site',$id_site);
        }
        $query->delete();
        return true;
    }
    public static function selectByBrand($id_brand){
        $query = "SELECT m_site.*,map_site_brand.id_brand from m_site";
        $query .= " join map_site_brand on map_site_brand.id_site = m_site.site_id";
        $query .= " where m_site.deleted = 1";
        $query .= " and map_site_brand.id_brand = ".$id_brand;
        return DB::select($query);
    }

    public static function selectByBrandProvince($id_brand,$id_provinsi){
        $query = "SELECT m_site.*,map_site_brand.id_brand from m_site";
        $query .= " join map_site_brand on map_site_brand.id_site = m_site.site_id";
        $query .= " where m_site.deleted = 1";
        $query .= " and m_site.id_provinsi = ".$id_provinsi;
        $query .= " and map_site_brand.id_brand = ".$id_brand;
        return DB::select($query);
    }

    public static function selectDeviceWSiteIDStatusDevice($site_id,$status_record){
        $query = "SELECT m_device.* from m_device where site_id = ".$site_id." and status_record = ".$status_record." and deleted = 1";
        return DB::select($query);
    }

    public static function updateDeviceZero($id){
        DB::table('m_device')->where('site_id', $id)->update(['status_record'=>0]);
        return true;
    }
    public static function updateDeviceSR($id){
        DB::table('m_device')->where('device_id', $id)->update(['status_record'=>1]);
        return true;
    }

    public static function selectWhereIn($site_id){
        $query = DB::table('m_site')->where('deleted', 1)->whereIn('site_id',$site_id);
        return $query;
    }

    public static function cekDuplicate($id_site,$site_code,$key_outlet){
        $query = "SELECT count(*) from m_site where site_id != ".$id_site." and deleted = 1 and (site_code = '".$site_code."' or key_outlet = '".$key_outlet."' )";
        return DB::select($query);
    }
}
