<?php

namespace App\Http\Traits;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

trait Helper
{
    public static function convertDate($tgl, $tampil_hari=true, $with_menit = true){
        if ($tgl != null ||  $tgl != "") {
                $nama_hari    =   array("Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jum'at", "Sabtu");
                $nama_bulan   =   array (
                                    1 => "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus","September", "Oktober", "November", "Desember"
                                );
                $tahun        =   substr($tgl,0,4);
                $bulan        =   $nama_bulan[(int)substr($tgl,5,2)];
                $tanggal      =   substr($tgl,8,2);

                $text         =   "";

                if ($tampil_hari) {

                    $urutan_hari  =   date('w', mktime(0,0,0, substr($tgl,5,2), $tanggal, $tahun));
                    $hari         =   $nama_hari[$urutan_hari];
                    $text         .=  $hari.", ";

                }

                $text         .=$tanggal ." ". $bulan ." ". $tahun;

                if ($with_menit) {

                $jam    =   substr($tgl,11,2);
                $menit  =   substr($tgl,14,2);

                $text   .=  ", ".$jam.":".$menit;

                }


        }else{

            $text = "-";
        }
    return $text;
    }
    function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }    
    function showData($data,$column){
        if($data != null){
                return $data->{$column};
            
        }else{
            if(old($column)){
                if($column == 'tanggal_start' || $column == 'tanggal_end'){
                    return date('Y-m-d',strtotime(old($column)));
                }else{
                    return old($column);
                }
            }
        }
    }
    function showDataDate($data,$column){
        if($data != null){
            if(strtotime($data->{$column})){
                return date('Y-m-d',strtotime($data->{$column}));
            }else{
                return $data->{$column};
            }
        }else{
            if(old($column)){
                if($column == 'tanggal_start' || $column == 'tanggal_end'){
                    return date('Y-m-d',strtotime(old($column)));
                }else{
                    return old($column);
                }
            }
        }
    }
    function showDataSelected($data,$column,$value){
        if($data != null){
            if($data->{$column} == $value){
                return 'selected';
            };
        }
    }
    function showDataChecked($data,$column,$value){
        if($data != null){
            if($data->{$column} == $value){
                return 'checked';
            };
        }
    }
    public function calculateDistanceMinutes($value1,$value2)
    {
        //15:00:00 -- 23:00:00
        //23 - 15 = 8
        // $value1 = date("H:i:s",strtotime("01/01/2022 11:00:00 PM"));
        // $value2 = date("H:i:s",strtotime("02/01/2022 07:00:00 AM"));
        // dd($value1);
        $time = strtotime($value2) - strtotime($value1);
        
        $minutes = $this->getMinutes($time);
        return $minutes;
    }

    function getSemestersFromPast($numberOfSemesters) {
        $today = new \DateTime(); // Tanggal saat ini
        $semesters = array();
    
        for ($i = 0; $i < $numberOfSemesters; $i++) {
            $endMonth = $today->format('n'); // Bulan akhir semester
            $endYear = $today->format('Y'); // Tahun akhir semester
    
            // Semester kedua (Juli - Desember)
            if ($endMonth >= 7) {
                $startMonth = 7;
                $startYear = $endYear;
                $semesterType = 2;
            } else {
                // Semester pertama (Januari - Juni)
                $startMonth = 1;
                $startYear = $endYear;
                $semesterType = 1;
            }
    
            $semester = $endYear." - ".$semesterType;
            array_push($semesters, $semester);
    
            // Pindah ke semester sebelumnya
            $today->modify('-6 months');
            // array_push($semesters, $today);
        }
    
        return $semesters;
    }

    function getSemestersFromYears($year){
        $today = new \DateTime(); // Tanggal saat ini
        $semesters = array();
        $this_year = $today->format('Y');
        $diff_year = $this_year-$year;
        $limit = ($diff_year*2) + 2;
        $nextYear = $year;
        for ($i = 0; $i < $limit; $i++) {
            
            if($i == 0 || $i%2 == 0){
                $endYear = $nextYear;
                $semesterType = 1;
            } else {
                $semesterType = 2;
                $nextYear = $endYear +1;
            }
    
            $semester = $endYear." - ".$semesterType;
            array_push($semesters, $semester);
        }
    
        return $semesters;
    }
   
}