<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\TObjek;
use App\Models\MProvinsi;
use App\Models\MKota;
use App\Models\MRuas;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Config;

class CLogin extends Controller
{    
    public function index()
    {
         return view('login')
            ->with('titlepage','Login')
            ->with('title','PAJA - Pawang Jalan');
    }

    public function landing()
    {   
        $objek = TObjek::where('deleted',1)->count();
        // $provinsi = MProvinsi::where('deleted',1)->count();
        $provinsi = MProvinsi::landingProvinsi()->get()->count();
        // $kota = MKota::where('deleted',1)->count();
        $kota = MKota::landingKota()->get()->count();
        // $ruas = MRuas::where('deleted',1)->count();
        $ruas = MRuas::landingRuas()->get()->count();
         return view('landing')
            ->with('titlepage','Landing PAJA')
            ->with('title','PAJA - Pawang Jalan')
            ->with('provinsi',$provinsi)
            ->with('kota',$kota)
            ->with('ruas',$ruas)
            ->with('objek',$objek);
    }
    public function authenticate(Request $request)
    {

        $credentials = $request->validate([
            'username' => ['required'],
            'password' => ['required'],
            'bussiness_code' => ['required'],
        ]);
        $sp_code = config('constants.bussiness_code');
        if($sp_code == $request->bussiness_code){
            if (Auth::attempt(['email' => $request->username, 'password' => $request->password, 'deleted' => 1])) {
                return redirect(url('bussiness'));            
            } else {
                return back()->with('msg','Wrong Username / Password');
            }
        } else {
            $data_bussiness = DB::table('m_bussiness')->where('bussiness_code',$request->bussiness_code);
            //dd($data_bussiness->first());
            if($data_bussiness->count() > 0){
                $this->_connect_data($data_bussiness->first());
                config(['database.default' => 'user_connection_login']);
                session(['dt_bussiness' => $data_bussiness->first()]);
                //$_SESSION['dt_bussiness'] = $data_bussiness->first();
            }
            //dd(DB::connection()->getDatabaseName());
            if (Auth::attempt(['email' => $request->username, 'password' => $request->password, 'deleted' => 1])) {
                return redirect(url('dashboard'));            
            } else {
                return back()->with('msg','Wrong Username / Password');
            }
        }
        
        
         
        
    }
    public function logout(Request $request)
    {
        Auth::logout();
 
        $request->session()->invalidate();
    
        $request->session()->regenerateToken();
    
        return redirect('/');
    }
    public function _connect_data($data){
        $expolde_pass = explode('"',Crypt::decryptString($data->bussiness_dbpass));
        Config::set('database.connections.user_connection_login', [
            'driver' => 'pgsql',
            'host' => $data->bussiness_dbhost,
            'port' => $data->bussiness_dbport,
            'database' => $data->bussiness_db,
            'username' => $data->bussiness_dbuser,
            'password' => $expolde_pass[0],
            'charset' => 'utf8',
            'prefix' => '',
            'schema' => $data->bussiness_dbschema,
            'sslmode' => 'prefer',
        ]);
        //print_r($expolde_pass[1]);exit();
        DB::purge('user_connection_login');
        DB::reconnect('user_connection_login');
    }
}
