<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\IOFactory;
use App\Models\MDevice;
use App\Models\MCountPeople;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class CExcel extends Controller
{
    public function uploadCsv(){
        return view('upload_csv')
            ->with('titlepage','Upload CSV')
            ->with('title','Camera');
    }
    public function readCsv(Request $request){
        $request->validate([
            'csv_file' => 'required|mimes:csv,txt',
            'date' => 'required'
        ]);
        // Load the uploaded CSV file
        $filePath = $request->file('csv_file')->getRealPath();
        $spreadsheet = IOFactory::load($filePath);
    
        // Get the first worksheet
        $sheet = $spreadsheet->getActiveSheet();
        $data = [];
        $dataTime = [];
        $date = $request->post('date');
        // Loop through each row in the CSV
        $this->_connect_data_excel();
        config(['database.default' => 'user_connection_excel']);
        foreach ($sheet->getRowIterator() as $row) {
            $cellData = [];
            $cellIterator = $row->getCellIterator();
            $cellIterator->setIterateOnlyExistingCells(false); // Include all cells, even empty ones

            // Check and transform the first cell value
            $firstCell = $cellIterator->current();
            $firstCellValue = $firstCell->getValue();

            // Skip this row if the first cell is "location"
            if (strtolower($firstCellValue) === 'location') {
                //continue;
                //$i = 0;
                foreach ($cellIterator as $cell) {
                    /*if($i == 0){
                        $i++;
                        continue;
                    }*/
                    $cellData[] = $cell->getValue();
                }

                $dataTime[] = $cellData;
            } else if (strtolower($firstCellValue) === 'total daily') {
                continue;
            } else if (strtolower($firstCellValue) === 'total yesterday') {
                continue;
            } else {
                // Uppercase the first cell value
                $upperFC = strtoupper($firstCellValue);
                $cellData[] = $upperFC;
                $i = 0;
                $device_id = 0;
                $site_id = 1;
                $site_name = 'Diky Shoes 2';
                foreach ($cellIterator as $cell) {
                    if($i == 0){
                        $cek_device = MDevice::checkExistByName($upperFC)->get();
                        if(count($cek_device) > 0){
                            $device_id = $cek_device[0]->device_id;
                        } else {
                            $arr_device = ['device_name'=>$upperFC,'device_code'=>$upperFC,'status'=>0,'deleted'=>1,'status_record'=>1,'site_id'=>$site_id];
                            $device_id = MDevice::insert_q($arr_device);
                        }
                        $i++;
                        continue;
                    } else {   
                        $val_enter = $cell->getValue();
                        $time = $dataTime[0][$i];    
                        $explode_time = explode(':',$time);
                        $int_time = intval($explode_time[0]);
                        $next_time = $int_time+1;
                        DB::table('t_count_people')->insert([
                            'site_id' => $site_id,
                            'site_name' => $site_name,
                            'device_id' => $device_id,
                            'device_name' => $upperFC,
                            'start_time' => $date.' '.$time,
                            'end_time' => $date.' '.$next_time.':00',
                            'enter' => $val_enter,
                            'exit' => 0,
                            'status' => 0,
                            'from_migration' => 5,
                        ]);
                        $i++;
                    }
                    $cellData[] = $cell->getValue();
                }

                $data[] = $cellData; // Add the row to data if it passes the filter
            }
        }
    
        Session::flash('success', 'CSV data uploaded and saved successfully!');

        // Redirect back to the upload page
        return redirect()->back();
    }

    public function _connect_data_excel(){
        //$expolde_pass = explode('"',Crypt::decryptString($data->bussiness_dbpass));
        Config::set('database.connections.user_connection_excel', [
            'driver' => 'pgsql',
            'host' => '127.0.0.1',
            'port' => '5432',
            'database' => 'pc_harmoni_exchange_2',
            'username' => 'postgres',
            'password' => 'dVJE!QiR@zG#1a@byFtKGvWGkTU&*W5RY!!A01xUkLyG#sQTT',
            'charset' => 'utf8',
            'prefix' => '',
            'schema' => 'public',
            'sslmode' => 'prefer',
        ]);
        //print_r($expolde_pass[1]);exit();
        DB::purge('user_connection_excel');
        DB::reconnect('user_connection_excel');
    }
}