<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use phpDocumentor\Reflection\DocBlock\Tags\See;
use App\Http\Traits\Helper;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Models\MDevice;
use App\Models\User;
use App\Models\MSite;
use Illuminate\Support\Facades\Validator;

class CDevice extends Controller
{    
    public function index()
    {   
        return view('device.index')
            ->with('titlepage','Device')
            ->with('title','Camera');
    }

    public function get_data()
    {   
        
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user = User::getUserById($id_user)->first();
        $start = $_GET['start'];
        $search = $_GET['search']['value'];
        $sortColumnName = $_GET['columns'][$_GET["order"][0]['column']]['name'];
        $sortDirection = $_GET['order'][0]['dir'];
        $draw = $_GET['draw'];
        $id_level = $user->id_level;
        $str_list_site = $user->list_user;
        $length = 0;
        //dd($length);
        if($_GET['length'] == 'all'){
            //$user = MBrand::selectDataTables(0, $start, 0, $search, $sortColumnName, $sortDirection); 
            $length = 0;
        } else {
            $length = $_GET['length'];
            //$user = MBrand::selectDataTables(0, $start, intval($length), $search, $sortColumnName, $sortDirection);
        }

        if ($id_level != 4 || $str_list_site == null)
        {
            //$site_id, $site_code, $start, $length, $search, $sort, $sort_direction,$store_availibility
            $device = MDevice::selectDataTables(0,"",$start, $length,$search,$sortColumnName,$sortDirection);
            $recordsTotal = MDevice::TotalDataV1($search)[0]->count;
            $recordsFiltered = MDevice::TotalDataV1($search)[0]->count;
        } else {
            //$site_ids = [];
            $site_ids = explode(',',$str_list_site);
            $device = MDevice::selectDataTablesV2(0, "",$site_ids, $start, $length, $search, $sortColumnName, $sortDirection)->get();
            $recordsTotal = MDevice::TotalDataV2($site_ids, $search);
            $recordsFiltered = MDevice::TotalDataV2($site_ids, $search);
        }
        foreach($device as $item){
            if ($item->status == 0)
            {
                $item->status_msg = "Online";
            } else if ($item->status == 1)
            {
                $item->status_msg = "Offline";
            } else if ($item->status == 2)
            {
                $item->status_msg = "Offline";
            } else if ($item->status == 3)
            {
                $item->status_msg = "Offline";
            } else if ($item->status == 4)
            {
                $item->status_msg = "Offline";
            } else if ($item->status == 5)
            {
                $item->status_msg = "Online";
            } else if ($item->status == 6)
            {
                $item->status_msg = "Offline";
            } else {
                $item->status_msg = "Offline";
            }
            if($item->last_report != null){
                $last_report = strtotime($item->last_report);
                //strtotime
                $item->last_update = date('Y-m-d H:i',$last_report);
            } else {
                $item->last_update = "-";
            }
        }
        $output = array(
			"draw" => $_GET['draw'],
			"recordsTotal" => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data" => $device,
		);
		echo json_encode($output, JSON_PRETTY_PRINT);
    }

    public function create()
    {   
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user = User::getUserById($id_user)->first();
        $id_level = $user->id_level;
        $str_list_site = $user->list_user;
        if ($id_level != 4 || $str_list_site == null)
        {
            $site = MSite::selectDataTables(0, "")->get();
        } else {
            $site_ids = explode(',',$str_list_site);
            $site = MSite::selectWhereIn($site_ids)->get();
        }
        $all_id = [];
        $site_valid = [];
        $i = 0;
        $is_dev = config('constants.is_dev');
        foreach($site as $item){
            if($item->key_outlet != null && $item->key_outlet != ''){
                if($is_dev){
                    $key = config('constants.api_key_dev');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($item->key_outlet);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    $last10Characters = substr($check_key, -10);
                    if($ket_rm_salt == $item->site_code){
                        if($last10Characters == "develop123"){
                            $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                            if($cek_duplicate[0]->count == 0){
                                $item->status_msg = "Valid Key";
                                $item->status = 1;
                                $all_id[$i] = $item->site_id;
                                $i++;
                                array_push($site_valid,$item);
                            } else {
                                $item->status_msg = "Invalid Key";
                                $item->status = 2;
                            }
                        } else {
                            $item->status_msg = "Invalid Key";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "Invalid Key";
                        $item->status = 2;
                    }
                } else {
                    $key = config('constants.api_key_prod');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($check_key);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    if($ket_rm_salt == $item->site_code){
                        $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                        if($cek_duplicate[0]->count == 0){
                            $item->status_msg = "Valid Key";
                            $item->status = 1;
                            $all_id[$i] = $item->site_id;
                            $i++;
                            array_push($site_valid,$item);
                        } else {
                            $item->status_msg = "Invalid Key";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "Invalid Key";
                        $item->status = 2;
                    }
                }
            } else {
                $item->status_msg = "Invalid Key";
                $item->status = 2;;
            }
        }
        
        
        return view('device.create')
            ->with('titlepage','New Device')
            ->with('site_valid',$site_valid)
            ->with('title','Camera');
    }

    public function create_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'device_name' => 'required', 
            'device_code' => 'required', 
            'site_id' => 'required', 
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $data = ['device_name' =>$request->device_name,
                    'device_code' =>$request->device_code,
                    'site_id' =>$request->site_id,
                    'ip_address' =>$request->ip_address,
                    'hostname' =>$request->hostname,
                    'serial_number' =>$request->serial_number,
                    'external_id' =>$request->external_id,
                    'status_record'=>1,
                    'status'=>1,
                    'last_report'=>null,
                    'object_type'=>0];
        MDevice::insert_q($data);
        return redirect(url('device'));
        
    }

    public function detail($id)
    {
        config(['database.default' => 'user_connection']);
        $data = MDevice::select_detail($id,'')->get();
        return view('device.detail')
            ->with('titlepage','Detail Device')
            ->with('data',$data[0])
            ->with('title','Camera');
    }
    public function edit($id)
    {   
        
        config(['database.default' => 'user_connection']);
        $user = Auth::user();
        $id_user = $user->id;
        $user = User::getUserById($id_user)->first();
        $data = MDevice::select_q($id,'',0)->get();
        $id_level = $user->id_level;
        $str_list_site = $user->list_user;
        if ($id_level != 4 || $str_list_site == null)
        {
            $site = MSite::selectDataTables(0, "")->get();
        } else {
            $site_ids = explode(',',$str_list_site);
            $site = MSite::selectWhereIn($site_ids)->get();
        }
        $all_id = [];
        $site_valid = [];
        $i = 0;
        $is_dev = config('constants.is_dev');
        foreach($site as $item){
            if($item->key_outlet != null && $item->key_outlet != ''){
                if($is_dev){
                    $key = config('constants.api_key_dev');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($item->key_outlet);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    $last10Characters = substr($check_key, -10);
                    if($ket_rm_salt == $item->site_code){
                        if($last10Characters == "develop123"){
                            $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                            if($cek_duplicate[0]->count == 0){
                                $item->status_msg = "Valid Key";
                                $item->status = 1;
                                $all_id[$i] = $item->site_id;
                                $i++;
                                array_push($site_valid,$item);
                            } else {
                                $item->status_msg = "Invalid Key";
                                $item->status = 2;
                            }
                        } else {
                            $item->status_msg = "Invalid Key";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "Invalid Key";
                        $item->status = 2;
                    }
                } else {
                    $key = config('constants.api_key_prod');
                    $check_key = $this->_decrypt_key($item->key_outlet,$key);
                    //dd($check_key);
                    $ket_rm_salt =substr($check_key, 0, -10);
                    if($ket_rm_salt == $item->site_code){
                        $cek_duplicate = MSite::cekDuplicate($item->site_id,$item->site_code, $item->key_outlet);
                        if($cek_duplicate[0]->count == 0){
                            $item->status_msg = "Valid Key";
                            $item->status = 1;
                            $all_id[$i] = $item->site_id;
                            $i++;
                            array_push($site_valid,$item);
                        } else {
                            $item->status_msg = "Invalid Key";
                            $item->status = 2;
                        }
                    } else {
                        $item->status_msg = "Invalid Key";
                        $item->status = 2;
                    }
                }
            } else {
                $item->status_msg = "Invalid Key";
                $item->status = 2;;
            }
        }
        return view('device.edit')
            ->with('titlepage','Update Device')
            ->with('data',$data[0])
            ->with('site_valid',$site_valid)
            ->with('title','Camera');
    }

    public function edit_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'device_name' => 'required', 
            'device_code' => 'required', 
            'site_id' => 'required',
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $data = ['device_name' =>$request->device_name,
                'device_code' =>$request->device_code,
                'site_id' =>$request->site_id,
                'ip_address' =>$request->ip_address,
                'hostname' =>$request->hostname,
                'serial_number' =>$request->serial_number,
                'external_id' =>$request->external_id,
                'object_type'=>0];
        MDevice::update_q($request->device_id,$data);
        return redirect(url('device'));
        
    }
    public function delete($id)
    {
        config(['database.default' => 'user_connection']);
        MDevice::delete_q($id);            
        return response()->json(['message' => "Hapus Berhasil", 'Code' => "1" ]);
    }

    public function _decrypt_key($text,$key){
        //$encryptedData = base64_decode($text);
        $decryptedData = openssl_decrypt($text,'aes-128-ecb', $key,0,"");
        return $decryptedData;
    }
}
