<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use phpDocumentor\Reflection\DocBlock\Tags\See;
use App\Http\Traits\Helper;
use DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Models\MBrand;
use Illuminate\Support\Facades\Validator;

class CBrand extends Controller
{    
    public function index()
    {   
        return view('brand.index')
            ->with('titlepage','Brand')
            ->with('title','Camera');
    }

    public function get_data()
    {   
        config(['database.default' => 'user_connection']);
        $start = $_GET['start'];
        $search = $_GET['search']['value'];
        $sortColumnName = $_GET['columns'][$_GET["order"][0]['column']]['name'];
        $sortDirection = $_GET['order'][0]['dir'];
        $draw = $_GET['draw'];
        $length = $_GET['length'];
        //dd($length);
        if($length == 'all'){
            $user = MBrand::selectDataTables(0, $start, 0, $search, $sortColumnName, $sortDirection); 
        } else {
            $user = MBrand::selectDataTables(0, $start, intval($length), $search, $sortColumnName, $sortDirection);
        }
        $query = MBrand::TotalData_1(0,$search);
        $output = array(
			"draw" => $_GET['draw'],
			"recordsTotal" => $query[0]->count,
			"recordsFiltered" => $query[0]->count,
			"data" => $user,
		);
		echo json_encode($output, JSON_PRETTY_PRINT);
    }

    public function create()
    {   
        return view('brand.create')
            ->with('titlepage','New Brand')
            ->with('title','Camera');
    }

    public function create_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'nama_brand' => 'required', 
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $cek_nama = MBrand::cekNamaBrand(strtolower($request->nama_brand),0);
        if($cek_nama[0]->count == 0 && $request->nama_brand !=''){
            $user = Auth::user();
            $data = ['nama_brand' =>$request->nama_brand,
                    'created_by'=>$user->id,
                    'edited_by'=>0];
            MBrand::insert_q($data);
            return response()->json(['message'=>'Success','Code'=>1]);
        } else {
            return response()->json(['message'=>'Error Duplicate Name','Code'=>2]);
        }
        
    }

    public function edit($id)
    {   
        config(['database.default' => 'user_connection']);
        $data = MBrand::select_q($id);
        return view('brand.edit')
            ->with('titlepage','Update Brand')
            ->with('data',$data[0])
            ->with('title','Camera');
    }

    public function edit_save(Request $request)
    {   
        config(['database.default' => 'user_connection']);
        $validator = Validator::make($request->all(),[
            'nama_brand' => 'required', 
            'id_brand' => 'required', 
        ]);
        if ($validator->fails()) {          
            return response()->json(['status'=>false, 'error'=>$validator->errors(),'message'=>'Error','Code'=>2]);               
        }          
        $cek_nama = MBrand::cekNamaBrand(strtolower($request->nama_brand),$request->id_brand);
        //dd($cek_nama);
        if($cek_nama[0]->count == 0 && $request->nama_brand !=''){
            $user = Auth::user();
            $data = ['nama_brand' =>$request->nama_brand,
                    'edited_by'=>$user->id];
            MBrand::update_q($request->id_brand,$data);
            return response()->json(['message'=>'Success','Code'=>1]);
        } else {
            return response()->json(['message'=>'Error Duplicate Name','Code'=>2]);
        }
        
    }
    public function delete($id)
    {
        config(['database.default' => 'user_connection']);
        MBrand::delete_q($id);            
        return response()->json(['message' => "Hapus Berhasil", 'Code' => "1" ]);
    }

    public function CariBrandAll($id)
    {
        config(['database.default' => 'user_connection']);
        $data = MBrand::selectIn([])->get();            
        return response()->json($data);
    }
}
