<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Traits\Helper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use App\Models\MSite;
use App\Models\MDevice;
use App\Models\MCountPeople;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;


class CApi extends Controller
{    
    public function postCamera(Request $request){
        //config(['database.default' => 'user_connection']);
        $key = $request->header('secret-key');
        $decryptedKey = Crypt::decryptString($key);
        $arr_key = explode('##',$decryptedKey);
        
        $data_bussiness = DB::table('m_bussiness')->where('bussiness_id',$arr_key[1])->where('bussiness_code',$arr_key[0]);
        if($data_bussiness->count() > 0){
            $this->_connect_data($data_bussiness->first());
            $xmlData = file_get_contents("php://input");
            config(['database.default' => 'user_connection_api']);
            if (!empty($xmlData)) {
                $xml = simplexml_load_string($xmlData);
                $jsonArray = json_decode(json_encode($xml), true);
                $site_id = $jsonArray['@attributes']['SiteId'];
                $device_id = $jsonArray['@attributes']['DeviceId'];
                $hwPlatform = $jsonArray['Properties']['HwPlatform'];
                $camera_type = 1;
                $data_site = MSite::select_q(0,$site_id);
                if($hwPlatform == "1001" || $hwPlatform == "2000B" || $hwPlatform == "2000G2"){
                    $camera_type = 2;
                }
                if(count($data_site) > 0){
                    $id_site = $data_site[0]->site_id;
                } else {
                    $arr_site = [
                        'sitename' => $jsonArray['@attributes']['Sitename'],
                        'site_code'=> $site_id,
                        'divison_id' => $jsonArray['@attributes']['DivisionId'],
                        'key_outlet' => '',
                    ];
                    $id_site = MSite::insert_q($arr_site);
                }
                $data_device = MDevice::select_q(0,$device_id,$id_site);
                if($data_device->count() > 0){
                    $id_device = $data_device->first()->device_id;
                    $currentDateTime = date('Y-m-d H:i:s');
                    $status = intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']);
                    $ip_address = $jsonArray['Properties']['IpAddress'];
                    MDevice::updateStatus($id_device,$status,$currentDateTime,$ip_address);
                } else {
                    $currentDateTime = date('Y-m-d H:i:s');
                    $arr_device = [
                        'site_id' => $id_site,
                        'device_name' => $jsonArray['@attributes']['Devicename'],
                        'device_code' => $device_id,
                        'ip_address' => $jsonArray['Properties']['IpAddress'],
                        'hostname' => $jsonArray['Properties']['HostName'],
                        'serial_number' => $jsonArray['Properties']['SerialNumber'],
                        'object_type' => $jsonArray['ReportData']['Report']['Object']['@attributes']['ObjectType'],
                        'external_id' => $jsonArray['ReportData']['Report']['Object']['@attributes']['Id'],
                        'last_report' => $currentDateTime,
                        'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                        'status_record' => 0,
                        'camera_type' => $camera_type,
                        'camera_type_val' => $hwPlatform,
                    ];
                    $id_device = MDevice::insert_q($arr_device);
                }
                $start_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['StartTime'];
                $end_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['EndTime'];
                DB::table('api_logs')->insert([
                    'site_id' => $id_site,
                    'device_id' => $id_device,
                    'ip_address' => $jsonArray['Properties']['IpAddress'],
                    'json' => json_encode($jsonArray),
                    'report_date' => $end_time,
                ]);
                DB::table('t_count_people')->insert([
                    'site_id' => $id_site,
                    'site_name' => $jsonArray['@attributes']['Sitename'],
                    'device_id' => $id_device,
                    'device_name' => $jsonArray['@attributes']['Devicename'],
                    'start_time' => $start_time,
                    'end_time' => $end_time,
                    'enter' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Enters']),
                    'exit' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Exits']),
                    'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                ]);
                //dd($id_device);
                return response()->json(['message'=>'Success','code'=>1,'jsonArray'=>$jsonArray]);
            } else {
                return response()->json(['message'=>'Error No Data','code'=>2]);
            }
        } else {
            return response()->json(['message'=>'Error Wrong Key','code'=>4]);
        }
        
    }

    public function postCameraByPass(Request $request){
        //config(['database.default' => 'user_connection']);
        // $key = 'eyJpdiI6IlNpbUZKNnFNVVZVcHhzSlpxdDVNdmc9PSIsInZhbHVlIjoiRk1QN0xwYTFWTXhWUkUvbGRlbUNvQTFPTGd0Ty9oTEJpMnlEcGhYSnExbz0iLCJtYWMiOiI2OTQyNGU5MDkyZjE3YjY2NTAyNjI3NTUzYzEyYTRiMWM1ZjlmNWJlMzg0YzgzYTFhNDg3ZTgxYzI4MzUxMGM0IiwidGFnIjoiIn0=';
        $key = 'eyJpdiI6IkNkWnNrWVBiSU9FU1hNbkVCT0xvUGc9PSIsInZhbHVlIjoibmI3cWVVeDEvZXJmVTRSM1hDTXBIUT09IiwibWFjIjoiNjU4NGE0Mjg1M2QyMjc1NjlkNWQ1YmQ0MzIzNmI0NWYzNjdhMWNiNzY0ZWJiZjA2MGM3YWZhMDExN2I0MWVmYyIsInRhZyI6IiJ9';
        
        $decryptedKey = Crypt::decryptString($key);
        $arr_key = explode('##',$decryptedKey);
        
        $data_bussiness = DB::table('m_bussiness')->where('bussiness_id',$arr_key[1])->where('bussiness_code',$arr_key[0]);
        if($data_bussiness->count() > 0){
            $this->_connect_data($data_bussiness->first());
            $xmlData = file_get_contents("php://input");
            config(['database.default' => 'user_connection_api']);
            if (!empty($xmlData)) {
                $xml = simplexml_load_string($xmlData);
                $jsonArray = json_decode(json_encode($xml), true);
                $site_id = $jsonArray['@attributes']['SiteId'];
                $device_id = $jsonArray['@attributes']['DeviceId'];
                $hwPlatform = $jsonArray['Properties']['HwPlatform'];
                $camera_type = 1;
                $data_site = MSite::select_q(0,$site_id);
                if($hwPlatform == "1001" || $hwPlatform == "2000B" || $hwPlatform == "2000G2"){
                    $camera_type = 2;
                }
                if(count($data_site) > 0){
                    $id_site = $data_site[0]->site_id;
                } else {
                    $arr_site = [
                        'sitename' => $jsonArray['@attributes']['Sitename'],
                        'site_code'=> $site_id,
                        'divison_id' => $jsonArray['@attributes']['DivisionId'],
                        'key_outlet' => '',
                    ];
                    $id_site = MSite::insert_q($arr_site);
                }
                $data_device = MDevice::select_q(0,$device_id,$id_site);
                if($data_device->count() > 0){
                    $id_device = $data_device->first()->device_id;
                    $currentDateTime = date('Y-m-d H:i:s');
                    $status = intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']);
                    $ip_address = $jsonArray['Properties']['IpAddress'];
                    MDevice::updateStatus($id_device,$status,$currentDateTime,$ip_address);
                } else {
                    $currentDateTime = date('Y-m-d H:i:s');
                    $arr_device = [
                        'site_id' => $id_site,
                        'device_name' => $jsonArray['@attributes']['Devicename'],
                        'device_code' => $device_id,
                        'ip_address' => $jsonArray['Properties']['IpAddress'],
                        'hostname' => $jsonArray['Properties']['HostName'],
                        'serial_number' => $jsonArray['Properties']['SerialNumber'],
                        'object_type' => $jsonArray['ReportData']['Report']['Object']['@attributes']['ObjectType'],
                        'external_id' => $jsonArray['ReportData']['Report']['Object']['@attributes']['Id'],
                        'last_report' => $currentDateTime,
                        'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                        'status_record' => 0,
                        'camera_type' => $camera_type,
                        'camera_type_val' => $hwPlatform,
                    ];
                    $id_device = MDevice::insert_q($arr_device);
                }
                $start_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['StartTime'];
                $end_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['EndTime'];
                DB::table('api_logs')->insert([
                    'site_id' => $id_site,
                    'device_id' => $id_device,
                    'ip_address' => $jsonArray['Properties']['IpAddress'],
                    'json' => json_encode($jsonArray),
                    'report_date' => $end_time,
                ]);
                DB::table('t_count_people')->insert([
                    'site_id' => $id_site,
                    'site_name' => $jsonArray['@attributes']['Sitename'],
                    'device_id' => $id_device,
                    'device_name' => $jsonArray['@attributes']['Devicename'],
                    'start_time' => $start_time,
                    'end_time' => $end_time,
                    'enter' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Enters']),
                    'exit' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Exits']),
                    'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                ]);
                //dd($id_device);
                return response()->json(['message'=>'Success','code'=>1,'jsonArray'=>$jsonArray]);
            } else {
                return response()->json(['message'=>'Error No Data','code'=>2]);
            }
        } else {
            return response()->json(['message'=>'Error Wrong Key','code'=>4]);
        }
        
    }
    public function postCameraParam(Request $request,$bussiness_code){
        //config(['database.default' => 'user_connection']);
        // dd($bussiness_code);
        // $key = 'eyJpdiI6IlNpbUZKNnFNVVZVcHhzSlpxdDVNdmc9PSIsInZhbHVlIjoiRk1QN0xwYTFWTXhWUkUvbGRlbUNvQTFPTGd0Ty9oTEJpMnlEcGhYSnExbz0iLCJtYWMiOiI2OTQyNGU5MDkyZjE3YjY2NTAyNjI3NTUzYzEyYTRiMWM1ZjlmNWJlMzg0YzgzYTFhNDg3ZTgxYzI4MzUxMGM0IiwidGFnIjoiIn0=';
        // $key = 'eyJpdiI6IkNkWnNrWVBiSU9FU1hNbkVCT0xvUGc9PSIsInZhbHVlIjoibmI3cWVVeDEvZXJmVTRSM1hDTXBIUT09IiwibWFjIjoiNjU4NGE0Mjg1M2QyMjc1NjlkNWQ1YmQ0MzIzNmI0NWYzNjdhMWNiNzY0ZWJiZjA2MGM3YWZhMDExN2I0MWVmYyIsInRhZyI6IiJ9';
        // $key = 'eyJpdiI6IlRIc3creGVQaTVmc0dBelRpQTdDakE9PSIsInZhbHVlIjoiOHJnSVp2STY2MDhhQjFvRWZpMS8xUT09IiwibWFjIjoiOWJhYjE3NzYyNmJjOGMzNzY0YTQ2MzljNGQ0Yzc4ZjFkZTk3YzQ5NmUyMjgxYzE2OTM5YWM4ODgzY2ZmOTU5MiIsInRhZyI6IiJ9=';

        // $decryptedKey = Crypt::decryptString($key);
        // $arr_key = explode('##',$decryptedKey);
        // dd($bussiness_code);
        $data_bussiness = DB::table('m_bussiness')->where('bussiness_code',$bussiness_code);
        if (!$data_bussiness->first() && $data_bussiness->count() == 0) {
            return response()->json(['message'=>'Bussiness Code didnt exist','code'=>4]);
        }
        if($data_bussiness->count() > 0){
            // dd($data_bussiness->first());
            
            $this->_connect_data($data_bussiness->first());
            $xmlData = file_get_contents("php://input");
            config(['database.default' => 'user_connection_api']);
            
            if (!empty($xmlData)) {

                $xml = simplexml_load_string($xmlData);
                $jsonArray = json_decode(json_encode($xml), true);
                $site_id = $jsonArray['@attributes']['SiteId'];
                $device_id = $jsonArray['@attributes']['DeviceId'];
                $hwPlatform = $jsonArray['Properties']['HwPlatform'];
                $camera_type = 1;
                $data_site = MSite::select_q(0,$site_id);
                if($hwPlatform == "1001" || $hwPlatform == "2000B" || $hwPlatform == "2000G2"){
                    $camera_type = 2;
                }
                if(count($data_site) > 0){
                    $id_site = $data_site[0]->site_id;
                } else {
                    $arr_site = [
                        'sitename' => $jsonArray['@attributes']['Sitename'],
                        'site_code'=> $site_id,
                        'divison_id' => $jsonArray['@attributes']['DivisionId'],
                        'key_outlet' => '',
                    ];
                    $id_site = MSite::insert_q($arr_site);
                }
                $data_device = MDevice::select_q(0,$device_id,$id_site);
                if($data_device->count() > 0){
                    $id_device = $data_device->first()->device_id;
                    $currentDateTime = date('Y-m-d H:i:s');
                    $status = intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']);
                    $ip_address = $jsonArray['Properties']['IpAddress'];
                    MDevice::updateStatus($id_device,$status,$currentDateTime,$ip_address);
                } else {
                    $currentDateTime = date('Y-m-d H:i:s');
                    $arr_device = [
                        'site_id' => $id_site,
                        'device_name' => $jsonArray['@attributes']['Devicename'],
                        'device_code' => $device_id,
                        'ip_address' => $jsonArray['Properties']['IpAddress'],
                        'hostname' => $jsonArray['Properties']['HostName'],
                        'serial_number' => $jsonArray['Properties']['SerialNumber'],
                        'object_type' => $jsonArray['ReportData']['Report']['Object']['@attributes']['ObjectType'],
                        'external_id' => $jsonArray['ReportData']['Report']['Object']['@attributes']['Id'],
                        'last_report' => $currentDateTime,
                        'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                        'status_record' => 0,
                        'camera_type' => $camera_type,
                        'camera_type_val' => $hwPlatform,
                    ];
                    $id_device = MDevice::insert_q($arr_device);
                }
                $start_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['StartTime'];
                $end_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['EndTime'];
                DB::table('api_logs')->insert([
                    'site_id' => $id_site,
                    'device_id' => $id_device,
                    'ip_address' => $jsonArray['Properties']['IpAddress'],
                    'json' => json_encode($jsonArray),
                    'report_date' => $end_time,
                ]);
                DB::table('t_count_people')->insert([
                    'site_id' => $id_site,
                    'site_name' => $jsonArray['@attributes']['Sitename'],
                    'device_id' => $id_device,
                    'device_name' => $jsonArray['@attributes']['Devicename'],
                    'start_time' => $start_time,
                    'end_time' => $end_time,
                    'enter' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Enters']),
                    'exit' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Exits']),
                    'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                ]);
                return response()->json(['message'=>'Success','code'=>1,'jsonArray'=>$jsonArray]);
            } else {
                return response()->json(['message'=>'Error No Data','code'=>2]);
            }
        } else {
            return response()->json(['message'=>'Error Wrong Key','code'=>4]);
        }

    }
    public function postCamera_v2(Request $request){
        //config(['database.default' => 'user_connection']);
        /*$key = $request->header('secret-key');
        $decryptedKey = Crypt::decryptString($key);
        $arr_key = explode('##',$decryptedKey);*/
        $xmlData = file_get_contents("php://input");
        if (!empty($xmlData)) {
            $xml = simplexml_load_string($xmlData);
            $jsonArray = json_decode(json_encode($xml), true);
            $macAddress = $jsonArray['Properties']['MacAddress'].',';
            $data_bussiness = DB::table('m_bussiness')->where('list_mac_address','like','%'.$macAddress.'%');;
            if($data_bussiness->count() > 0){
                $this->_connect_data($data_bussiness->first());
                
                config(['database.default' => 'user_connection_api']);      
                $site_id = $jsonArray['@attributes']['SiteId'];
                $device_id = $jsonArray['@attributes']['DeviceId'];
                $hwPlatform = $jsonArray['Properties']['HwPlatform'];
                $camera_type = 1;
                $data_site = MSite::select_q(0,$site_id);
                if($hwPlatform == "1001" || $hwPlatform == "2000B" || $hwPlatform == "2000G2"){
                    $camera_type = 2;
                }
                if(count($data_site) > 0){
                    $id_site = $data_site[0]->site_id;
                } else {
                    $arr_site = [
                        'sitename' => $jsonArray['@attributes']['Sitename'],
                        'site_code'=> $site_id,
                        'divison_id' => $jsonArray['@attributes']['DivisionId'],
                        'key_outlet' => '',
                    ];
                    $id_site = MSite::insert_q($arr_site);
                }
                $data_device = MDevice::select_q(0,$device_id,$id_site);
                if($data_device->count() > 0){
                    $id_device = $data_device->first()->device_id;
                    $currentDateTime = date('Y-m-d H:i:s');
                    $status = intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']);
                    $ip_address = $jsonArray['Properties']['IpAddress'];
                    MDevice::updateStatus($id_device,$status,$currentDateTime,$ip_address);
                } else {
                    $currentDateTime = date('Y-m-d H:i:s');
                    $arr_device = [
                        'site_id' => $id_site,
                        'device_name' => $jsonArray['@attributes']['Devicename'],
                        'device_code' => $device_id,
                        'ip_address' => $jsonArray['Properties']['IpAddress'],
                        'hostname' => $jsonArray['Properties']['HostName'],
                        'serial_number' => $jsonArray['Properties']['SerialNumber'],
                        'object_type' => $jsonArray['ReportData']['Report']['Object']['@attributes']['ObjectType'],
                        'external_id' => $jsonArray['ReportData']['Report']['Object']['@attributes']['Id'],
                        'last_report' => $currentDateTime,
                        'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                        'status_record' => 0,
                        'camera_type' => $camera_type,
                        'camera_type_val' => $hwPlatform,
                    ];
                    $id_device = MDevice::insert_q($arr_device);
                }
                $start_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['StartTime'];
                $end_time = $jsonArray['ReportData']['Report']['@attributes']['Date'].' '.$jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['EndTime'];
                DB::table('api_logs')->insert([
                    'site_id' => $id_site,
                    'device_id' => $id_device,
                    'ip_address' => $jsonArray['Properties']['IpAddress'],
                    'json' => json_encode($jsonArray),
                    'report_date' => $end_time,
                ]);
                DB::table('t_count_people')->insert([
                    'site_id' => $id_site,
                    'site_name' => $jsonArray['@attributes']['Sitename'],
                    'device_id' => $id_device,
                    'device_name' => $jsonArray['@attributes']['Devicename'],
                    'start_time' => $start_time,
                    'end_time' => $end_time,
                    'enter' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Enters']),
                    'exit' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Exits']),
                    'status' => intval($jsonArray['ReportData']['Report']['Object']['Count']['@attributes']['Status']),
                ]);
                //dd($id_device);
                return response()->json(['message'=>'Success','code'=>1,'jsonArray'=>$jsonArray]);
                
            } else {
                return response()->json(['message'=>'Unlisted Mac Address','code'=>4]);
            }
        } else {
            return response()->json(['message'=>'Error No Data','code'=>2]);
        }
        
    }
    public function _connect_data($data){
        $expolde_pass = explode('"',Crypt::decryptString($data->bussiness_dbpass));
        Config::set('database.connections.user_connection_api', [
            'driver' => 'pgsql',
            'host' => $data->bussiness_dbhost,
            'port' => $data->bussiness_dbport,
            'database' => $data->bussiness_db,
            'username' => $data->bussiness_dbuser,
            'password' => $expolde_pass[0],
            'charset' => 'utf8',
            'prefix' => '',
            'schema' => $data->bussiness_dbschema,
            'sslmode' => 'prefer',
        ]);
        //print_r($expolde_pass[1]);exit();
        DB::purge('user_connection_api');
        DB::reconnect('user_connection_api');
    }
}
