<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\TObjek;
use App\Models\MJenisKerusakan;
use Illuminate\Support\Facades\DB;

class SendFile extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'demo:kirim-file-ke-python';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Mengirim file ke python';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $cekstatus = TObjek::where("deleted",1)
                        ->where('status_cron',1)
                        ->count();
        if($cekstatus == 0){
            $list_objek = TObjek::where("deleted",1)
                        ->where("status_cron",0)
                        ->limit(1)                        
                        ->get();

            $stop = false;
            foreach ($list_objek as $key => $value) {
                DB::table('t_objek')
                    ->where('id_objek', $value->id_objek)
                    ->update(['status_cron' => 1]);

                $file = public_path('upload/'.$value->path_file);
                
                $extension = pathinfo($file, PATHINFO_EXTENSION);
                
                if (in_array($extension, ['jpg', 'jpeg'])) {
                    // Handle file dengan ekstensi jpg atau jpeg
                    $url = "http://209.97.175.239:5000/detection-file";
                } elseif ($extension == "mp4") {
                    // Handle file dengan ekstensi mp4
                    $url = "http://209.97.175.239:5000/process_video";
                }

                $ch = curl_init();

                $authorizationHeader = sprintf("Authorization: VqbFzBBUHatQGqS7AaJdQ8gusRUZjlHQOCH5rdZbXbx1O3Vj8HJhXqEkFaycp6jYHmDJddEVeOgLvypk8yR8G2sPhjwR9Iq1ym8pdoLMFktShiTxqFsyPsY7");

                $headers = array(
                    $authorizationHeader,
                    'Content-Type: multipart/form-data',
                );

                $postData = array(
                    'file' => curl_file_create($file, mime_content_type($file), basename($file)),
                );

                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

                $response = curl_exec($ch);

                curl_close($ch);

                $res = json_decode($response);            

                DB::table('t_objek')
                    ->where('id_objek', $value->id_objek)
                    ->update([
                        'path_output_file' => $res->data->file_output,
                        'retak_memanjang' => $res->data->retak_memanjang,
                        'retak_melintang' => $res->data->retak_melintang,
                        'retak_buaya' => $res->data->retakbuaya,
                        'lubang' => $res->data->lubang,
                        'file_size' => $res->data->file_size,
                        'panjang_video' => $res->data->panjang_video,
                        'status_cron' => 2,
                        'updated_date' => date("Y-m-d H:i:s"),
                    ]);

                if($extension == "mp4"){
                    foreach ($res->data->data_frame as $frame){
                    // for ($i=0; $i < count($res->data->data_time) ; $i++) { 
                        $findKode = MJenisKerusakan::where('kode',$frame->label)->where('deleted',1)->first();

                        DB::table('t_objek_temuan')->insert([
                            'id_objek' => $value->id_objek,
                            'id_jenis_kerusakan' => $findKode->id_jenis_kerusakan,
                            'time' => $frame->data_time,
                            'path_foto' => $frame->frame_filename,
                        ]);
                        
                    }
                }
            }   
        }

        return true;
    }

}
